local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.require 'v037r1.CEntity'
shared.require 'CMatrix'
shared.require 'CVector'

shared.ffi.cdef[[
#pragma pack(push, 1)
struct SCActor : SCEntity {
    CPed* m_pGamePed;
    GTAREF m_marker;
    GTAREF m_arrow;
    bool m_bNeedsToCreateMarker;
    bool m_bInvulnerable;
};
typedef struct SCActor SCActor;
#pragma pack(pop)
]]

shared.validate_size('struct SCActor', 0x56)

local CActor_constructor = ffi.cast('void(__thiscall*)(SCActor*, int, SCVector, float)', 0x97C60)
local function CActor_new(...)
    local obj = ffi.new('struct SCActor[1]')
    CActor_constructor(obj, ...)
    return obj
end

local SCActor_mt = {
    Destroy = ffi.cast('void(__thiscall*)(SCActor*)', shared.GetAddress(0x97DA0)),
    PerformAnimation = ffi.cast('void(__thiscall*)(SCActor*, const char*, const char*, float, int, int, int, int, int)', shared.GetAddress(0x97E00)),
    SetRotation = ffi.cast('void(__thiscall*)(SCActor*, float)', shared.GetAddress(0x97F10)),
    SetHealth = ffi.cast('void(__thiscall*)(SCActor*, float)', shared.GetAddress(0x97F70)),
    GetHealth = ffi.cast('float(__thiscall*)(SCActor*)', shared.GetAddress(0x97F50)),
    SetInvulnerable = ffi.cast('void(__thiscall*)(SCActor*, bool)', shared.GetAddress(0x980A0)),
    SetArmour = ffi.cast('void(__thiscall*)(SCActor*, float)', shared.GetAddress(0x97FD0)),
    GetArmour = ffi.cast('float(__thiscall*)(SCActor*)', shared.GetAddress(0x97FB0)),
    SetState = ffi.cast('void(__thiscall*)(SCActor*, int)', shared.GetAddress(0x98000)),
    GetState = ffi.cast('int(__thiscall*)(SCActor*)', shared.GetAddress(0x97FF0)),
    IsDead = ffi.cast('BOOL(__thiscall*)(SCActor*)', shared.GetAddress(0x98020)),
    SetStatus = ffi.cast('void(__thiscall*)(SCActor*, int)', shared.GetAddress(0x98060)),
    GetStatus = ffi.cast('int(__thiscall*)(SCActor*)', shared.GetAddress(0x98050)),
}
SCActor_mt.__index = SCActor_mt
ffi.metatype('struct SCActor', SCActor_mt)

return {
    new = CActor_new,
}