local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.require 'v037r1.CEntity'
shared.require 'v037r1.CActor'
shared.require 'CMatrix'
shared.require 'CVector'

shared.ffi.cdef[[
#pragma pack(push, 1)
struct SActorInfo {
    ID m_nId;
    int m_nModel;
    SCVector m_position;
    float m_fRotation;
    float m_fHealth;
    bool m_bInvulnerable;
};
typedef struct SActorInfo SActorInfo;
#pragma pack(pop)

enum {
    MAX_ACTORS = 1000,
};

#pragma pack(push, 1)
struct SCActorPool {
    int m_nLargestId;
    SCActor* m_pObject[1000];
    BOOL m_bNotEmpty[1000];
    CPed* m_pGameObject[1000];
    int pad_2ee4[1000];
    int pad_3e84[1000];
};
typedef struct SCActorPool SCActorPool;
#pragma pack(pop)
]]

shared.validate_size('struct SActorInfo', 0x1b)
shared.validate_size('struct SCActorPool', 0x4e24)

local CActorPool_constructor = ffi.cast('void(__thiscall*)(SCActorPool*)', 0x16B0)
local CActorPool_destructor = ffi.cast('void(__thiscall*)(SCActorPool*)', 0x18D0)
local function CActorPool_new(...)
    local obj = ffi.gc(ffi.new('struct SCActorPool[1]'), CActorPool_destructor)
    CActorPool_constructor(obj, ...)
    return obj
end

local SCActorPool_mt = {
    Get = ffi.cast('SCActor * (__thiscall*)(SCActorPool*, ID)', shared.GetAddress(0x1600)),
    DoesExist = ffi.cast('BOOL(__thiscall*)(SCActorPool*, ID)', shared.GetAddress(0x1630)),
    UpdateLargestId = ffi.cast('void(__thiscall*)(SCActorPool*)', shared.GetAddress(0x1650)),
    Delete = ffi.cast('BOOL(__thiscall*)(SCActorPool*, ID)', shared.GetAddress(0x16E0)),
    Create = ffi.cast('BOOL(__thiscall*)(SCActorPool*, const SActorInfo*)', shared.GetAddress(0x18F0)),
    Find = ffi.cast('ID(__thiscall*)(SCActorPool*, CPed*)', shared.GetAddress(0x18A0)),
}
SCActorPool_mt.__index = SCActorPool_mt
ffi.metatype('struct SCActorPool', SCActorPool_mt)

return {
    new = CActorPool_new,
}