local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.require 'CRect'
shared.require 'v037r1.CFonts'

shared.ffi.cdef[[
enum SEntryType {
    ENTRY_TYPE_NONE = 0,
    ENTRY_TYPE_CHAT = 2,
    ENTRY_TYPE_INFO = 4,
    ENTRY_TYPE_DEBUG = 8,
};
typedef enum SEntryType SEntryType;

enum SDisplayMode {
    DISPLAY_MODE_OFF = 0,
    DISPLAY_MODE_NOSHADOW = 1,
    DISPLAY_MODE_NORMAL = 2,
};
typedef enum SDisplayMode SDisplayMode;

enum {
    MAX_MESSAGES = 100,
};

#pragma pack(push, 1)
struct SChatEntry {
    int m_timestamp;
    char m_szPrefix[28];
    char m_szText[144];
    char unused[64];
    int m_nType;
    D3DCOLOR m_textColor;
    D3DCOLOR m_prefixColor;
};
typedef struct SChatEntry SChatEntry;
#pragma pack(pop)

#pragma pack(push, 1)
struct SCChat {
    unsigned int m_nPageSize;
    char* m_szLastMessage;
    int m_nMode;
    bool m_bTimestamps;
    BOOL m_bDoesLogExist;
    char m_szLogPath[261];
    CDXUTDialog* m_pGameUi;
    CDXUTEditBox* m_pEditbox;
    CDXUTScrollBar* m_pScrollbar;
    D3DCOLOR m_textColor;
    D3DCOLOR m_infoColor;
    D3DCOLOR m_debugColor;
    long int m_nWindowBottom;
    SChatEntry m_entry[100];
    SCFonts* m_pFontRenderer;
    ID3DXSprite* m_pTextSprite;
    ID3DXSprite* m_pSprite;
    IDirect3DDevice9* m_pDevice;
    BOOL m_bRenderToSurface;
    ID3DXRenderToSurface* m_pRenderToSurface;
    IDirect3DTexture9* m_pTexture;
    IDirect3DSurface9* m_pSurface;
    unsigned int m_displayMode[4];
    int pad_[2];
    BOOL m_bRedraw;
    long int m_nScrollbarPos;
    long int m_nCharHeight;
    long int m_nTimestampWidth;
};
typedef struct SCChat SCChat;
#pragma pack(pop)
]]

shared.validate_size('struct SChatEntry', 0xfc)
shared.validate_size('struct SCChat', 0x63ea)

local function RefChat() return ffi.cast('SCChat**', shared.GetAddress(0x21A0E4))[0] end
local CChat_constructor = ffi.cast('void(__thiscall*)(SCChat*, IDirect3DDevice9*, SCFonts*, const char*)', 0x647B0)
local CChat_destructor = ffi.cast('void(__thiscall*)(SCChat*)', 0x63840)
local function CChat_new(...)
    local obj = ffi.gc(ffi.new('struct SCChat[1]'), CChat_destructor)
    CChat_constructor(obj, ...)
    return obj
end

local SCChat_mt = {
    -- GetMode = ...
    SwitchMode = ffi.cast('void(__thiscall*)(SCChat*)', shared.GetAddress(0x5D7B0)),
    RecalcFontSize = ffi.cast('void(__thiscall*)(SCChat*)', shared.GetAddress(0x63550)),
    OnLostDevice = ffi.cast('void(__thiscall*)(SCChat*)', shared.GetAddress(0x635D0)),
    UpdateScrollbar = ffi.cast('void(__thiscall*)(SCChat*)', shared.GetAddress(0x63630)),
    SetPageSize = ffi.cast('void(__thiscall*)(SCChat*, int)', shared.GetAddress(0x636D0)),
    PageUp = ffi.cast('void(__thiscall*)(SCChat*)', shared.GetAddress(0x63700)),
    PageDown = ffi.cast('void(__thiscall*)(SCChat*)', shared.GetAddress(0x63760)),
    ScrollToBottom = ffi.cast('void(__thiscall*)(SCChat*)', shared.GetAddress(0x637C0)),
    -- Scroll = ...
    FilterOutInvalidChars = ffi.cast('void(__thiscall*)(SCChat*, char*)', shared.GetAddress(0x63850)),
    -- PushBack = ...
    RenderEntry = ffi.cast('void(__thiscall*)(SCChat*, const char*, SCRect, D3DCOLOR)', shared.GetAddress(0x638A0)),
    Log = ffi.cast('void(__thiscall*)(SCChat*, int, const char*, const char*)', shared.GetAddress(0x63C00)),
    ResetDialogControls = ffi.cast('void(__thiscall*)(SCChat*, CDXUTDialog*)', shared.GetAddress(0x63CD0)),
    Render = ffi.cast('void(__thiscall*)(SCChat*)', shared.GetAddress(0x63D70)),
    AddEntry = ffi.cast('void(__thiscall*)(SCChat*, int, const char*, const char*, D3DCOLOR, D3DCOLOR)', shared.GetAddress(0x64010)),
    Draw = ffi.cast('void(__thiscall*)(SCChat*)', shared.GetAddress(0x64230)),
    -- RenderToSurface = ...
    AddChatMessage = ffi.cast('void(__thiscall*)(SCChat*, const char*, D3DCOLOR, const char*)', shared.GetAddress(0x64450)),
    AddMessage = ffi.cast('void(__thiscall*)(SCChat*, D3DCOLOR, const char*)', shared.GetAddress(0x645A0)),
    OnResetDevice = ffi.cast('void(__thiscall*)(SCChat*)', shared.GetAddress(0x64600)),
    -- Print = ...
}
SCChat_mt.__index = SCChat_mt
ffi.metatype('struct SCChat', SCChat_mt)

return {
    RefChat = RefChat,
    new = CChat_new,
}