local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.require 'CRect'
shared.require 'v037r1.Commands'

shared.ffi.cdef[[
enum {
    MAX_CLIENT_CMDS = 144,
    MAX_CMD_LENGTH = 32,
};

#pragma pack(push, 1)
struct SCInput {
    IDirect3DDevice9* m_pDevice;
    CDXUTDialog* m_pGameUi;
    CDXUTEditBox* m_pEditbox;
    CMDPROC m_pCommandProc[144];
    char m_szCommandName[33][144];
    int m_nCommandCount;
    BOOL m_bEnabled;
    char m_szInput[129];
    char m_szRecallBufffer[129][10];
    char m_szCurrentBuffer[129];
    int m_nCurrentRecall;
    int m_nTotalRecall;
    CMDPROC m_pDefaultCommand;
};
typedef struct SCInput SCInput;
#pragma pack(pop)
]]

shared.validate_size('struct SCInput', 0x1afc)

local Commands = {}

-- Default = ...
-- TestDeathWindow = ...
-- ToggleCameraTargetLabels = ...
-- SetChatPageSize = ...
-- SetChatFontSize = ...
-- DrawNameTagStatus = ...
-- DrawChatTimestamps = ...
-- ToggleAudioStreamMessages = ...
-- PrintMemory = ...
-- SetFrameLimiter = ...
-- ToggleHeadMoves = ...
-- Quit = ...
-- CmpStat = ...
-- SavePosition = ...
-- SavePositionOnly = ...
-- PrintCurrentInterior = ...
-- ToggleObjectsLight = ...
-- ToggleDebugLabels = ...
-- SendRconCommand = ...
Commands.Debug = {}

-- SetPlayerSkin = ...
-- CreateVehicle = ...
-- EnableVehicleSelection = ...
-- SetWorldWeather = ...
-- SetWorldTime = ...
-- Setup = ...
local function RefInputBox() return ffi.cast('SCInput**', shared.GetAddress(0x21A0E8))[0] end
local CInput_constructor = ffi.cast('void(__thiscall*)(SCInput*, IDirect3DDevice9*)', 0x65730)
local function CInput_new(...)
    local obj = ffi.new('struct SCInput[1]')
    CInput_constructor(obj, ...)
    return obj
end

local SCInput_mt = {
    GetRect = ffi.cast('void(__thiscall*)(SCInput*, SCRect*)', shared.GetAddress(0x657A0)),
    Open = ffi.cast('void(__thiscall*)(SCInput*)', shared.GetAddress(0x657E0)),
    Close = ffi.cast('void(__thiscall*)(SCInput*)', shared.GetAddress(0x658E0)),
    AddRecall = ffi.cast('void(__thiscall*)(SCInput*, const char*)', shared.GetAddress(0x65930)),
    RecallUp = ffi.cast('void(__thiscall*)(SCInput*)', shared.GetAddress(0x65990)),
    RecallDown = ffi.cast('void(__thiscall*)(SCInput*)', shared.GetAddress(0x65A00)),
    EnableCursor = ffi.cast('void(__thiscall*)(SCInput*)', shared.GetAddress(0x65A50)),
    GetCommandHandler = ffi.cast('CMDPROC(__thiscall*)(SCInput*, const char*)', shared.GetAddress(0x65A70)),
    SetDefaultCommand = ffi.cast('void(__thiscall*)(SCInput*, CMDPROC)', shared.GetAddress(0x65AC0)),
    AddCommand = ffi.cast('void(__thiscall*)(SCInput*, const char*, CMDPROC)', shared.GetAddress(0x65AD0)),
    MsgProc = ffi.cast('int(__thiscall*)(SCInput*, int, int, int)', shared.GetAddress(0x65B30)),
    ResetDialogControls = ffi.cast('void(__thiscall*)(SCInput*, CDXUTDialog*)', shared.GetAddress(0x65BA0)),
    Send = ffi.cast('void(__thiscall*)(SCInput*, const char*)', shared.GetAddress(0x65C60)),
    ProcessInput = ffi.cast('void(__thiscall*)(SCInput*)', shared.GetAddress(0x65D30)),
}
SCInput_mt.__index = SCInput_mt
ffi.metatype('struct SCInput', SCInput_mt)

return {
    Commands = Commands,
    RefInputBox = RefInputBox,
    new = CInput_new,
}