local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.require 'CVector'

shared.ffi.cdef[[
#pragma pack(push, 1)
struct SCLabel {
    IDirect3DDevice9* m_pDevice;
    ID3DXSprite* m_pSprite;
};
typedef struct SCLabel SCLabel;
#pragma pack(pop)
]]

shared.validate_size('struct SCLabel', 0x8)

local CLabel_constructor = ffi.cast('void(__thiscall*)(SCLabel*, IDirect3DDevice9*)', 0x674D0)
local CLabel_destructor = ffi.cast('void(__thiscall*)(SCLabel*)', 0x674F0)
local function CLabel_new(...)
    local obj = ffi.gc(ffi.new('struct SCLabel[1]'), CLabel_destructor)
    CLabel_constructor(obj, ...)
    return obj
end

local SCLabel_mt = {
    OnLostDevice = ffi.cast('void(__thiscall*)(SCLabel*)', shared.GetAddress(0x67510)),
    OnResetDevice = ffi.cast('void(__thiscall*)(SCLabel*)', shared.GetAddress(0x67520)),
    HasNoObstacles = ffi.cast('BOOL(__thiscall*)(SCLabel*, SCVector)', shared.GetAddress(0x67530)),
    Begin = ffi.cast('void(__thiscall*)(SCLabel*)', shared.GetAddress(0x67590)),
    End = ffi.cast('void(__thiscall*)(SCLabel*)', shared.GetAddress(0x675A0)),
    Draw = ffi.cast('void(__thiscall*)(SCLabel*, SCVector*, const char*, D3DCOLOR, bool, bool)', shared.GetAddress(0x675B0)),
}
SCLabel_mt.__index = SCLabel_mt
ffi.metatype('struct SCLabel', SCLabel_mt)

local function RefLabel() return ffi.cast('SCLabel**', shared.GetAddress(0x21A0C0))[0] end

return {
    new = CLabel_new,
    RefLabel = RefLabel,
}