local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.ffi.cdef[[
enum {
    MAX_MENU_ITEMS = 12,
    MAX_COLUMNS = 2,
    MAX_MENU_LINE = 32,
};

#pragma pack(push, 1)
struct SInteraction {
    BOOL m_bMenu;
    BOOL m_bRow[12];
    BOOL m_bPadding[3];
};
typedef struct SInteraction SInteraction;
#pragma pack(pop)

#pragma pack(push, 1)
struct SCMenu {
    unsigned char m_nId;
    char m_szTitle[32];
    char m_szItems[32][2][12];
    char m_szHeader[32][2];
    float m_fPosX;
    float m_fPosY;
    float m_fFirstColumnWidth;
    float m_fSecondColumnWidth;
    unsigned char m_nColumns;
    SInteraction m_interaction;
    unsigned char m_nColumnCount[2];
    GTAREF m_panel;
};
typedef struct SCMenu SCMenu;
#pragma pack(pop)
]]

shared.validate_size('struct SInteraction', 0x40)
shared.validate_size('struct SCMenu', 0x3b8)

local CMenu_constructor = ffi.cast('void(__thiscall*)(SCMenu*, const char*, float, float, float, float, const SInteraction*)', 0xA23C0)
local function CMenu_new(...)
    local obj = ffi.new('struct SCMenu[1]')
    CMenu_constructor(obj, ...)
    return obj
end

local SCMenu_mt = {
    AddItem = ffi.cast('void(__thiscall*)(SCMenu*, NUMBER, NUMBER, const char*)', shared.GetAddress(0xA2460)),
    SetColumnTitle = ffi.cast('void(__thiscall*)(SCMenu*, NUMBER, const char*)', shared.GetAddress(0xA2490)),
    Hide = ffi.cast('void(__thiscall*)(SCMenu*)', shared.GetAddress(0xA24C0)),
    GetItem = ffi.cast('char*(__thiscall*)(SCMenu*, NUMBER, NUMBER)', shared.GetAddress(0xA24E0)),
    GetTitle = ffi.cast('char*(__thiscall*)(SCMenu*)', shared.GetAddress(0xA2500)),
    MS = ffi.cast('char*(__thiscall*)(SCMenu*, NUMBER, NUMBER)', shared.GetAddress(0xA2530)),
    GetActiveRow = ffi.cast('char(__thiscall*)(SCMenu*)', shared.GetAddress(0xA2560)),
    Show = ffi.cast('void(__thiscall*)(SCMenu*)', shared.GetAddress(0xA2590)),
}
SCMenu_mt.__index = SCMenu_mt
ffi.metatype('struct SCMenu', SCMenu_mt)

return {
    new = CMenu_new,
}