local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.require 'CPoint'
shared.require 'CRect'
shared.require 'CMatrix'
shared.require 'CVector'

shared.ffi.cdef[[
enum SObjectEditType {
    OBJECT_EDIT_TYPE_NONE = 0,
    OBJECT_EDIT_TYPE_ATTACHEDOBJECT = 2,
    OBJECT_EDIT_TYPE_OBJECT = 1,
};
typedef enum SObjectEditType SObjectEditType;

enum SObjectEditMode {
    OBJECT_EDIT_MODE_POSITION = 0,
    OBJECT_EDIT_MODE_ROTATION = 1,
    OBJECT_EDIT_MODE_SCALE = 2,
};
typedef enum SObjectEditMode SObjectEditMode;

enum SObjectEditProcessType {
    OBJECT_EDIT_PROCESS_TYPE_XAXIS = 0,
    OBJECT_EDIT_PROCESS_TYPE_YAXIS = 1,
    OBJECT_EDIT_PROCESS_TYPE_ZAXIS = 2,
    OBJECT_EDIT_PROCESS_TYPE_SETPOSITION = 3,
    OBJECT_EDIT_PROCESS_TYPE_SETROTATION = 4,
    OBJECT_EDIT_PROCESS_TYPE_SETSCALE = 5,
    OBJECT_EDIT_PROCESS_TYPE_SAVE = 10,
};
typedef enum SObjectEditProcessType SObjectEditProcessType;

#pragma pack(push, 1)
struct SCObjectEdit {
    SCPoint m_CharMaxSize;
    SCRect m_xAxisButtonRect;
    SCRect m_yAxisButtonRect;
    SCRect m_zAxisButtonRect;
    SCRect m_PositionButtonRect;
    SCRect m_RotationButtonRect;
    SCRect m_ScaleButtonRect;
    SCRect m_SaveButtonRect;
    int m_nEditType;
    int m_nEditMode;
    BOOL m_bEnabled;
    BOOL m_bRenderedThisFrame;
    ID m_nEditObjectId;
    unsigned int m_nAttachedObjectIndex;
    BOOL m_bIsPlayerObject;
    SCVector m_vRotation;
    unsigned int m_nLastSentNotificationTick;
    bool m_bRenderScaleButton;
    bool m_bEditingRightNow;
    bool m_bTopXOfObjectIsOnLeftOfScreen;
    bool m_bTopYOfObjectIsOnLeftOfScreen;
    bool m_bTopZOfObjectIsOnLeftOfScreen;
    SCPoint m_EditStartPos;
    SCPoint m_CursorPosInGame;
    BOOL m_bObjectXSizeYCoordDiffMoreThanX;
    BOOL m_bObjectYSizeYCoordDiffMoreThanX;
    BOOL m_bObjectZSizeYCoordDiffMoreThanX;
    SCMatrix m_entityMatrix;
    IDirect3DDevice9* m_pDevice;
    ID3DXLine* m_pLine;
    ID3DXFont* m_pIconFontSmall;
    ID3DXFont* m_pIconFontBig;
    int m_nProcessType;
};
typedef struct SCObjectEdit SCObjectEdit;
#pragma pack(pop)
]]

shared.validate_size('struct SCObjectEdit', 0x117)

local CObjectEdit_constructor = ffi.cast('SCObjectEdit*(__thiscall*)(SCObjectEdit*, IDirect3DDevice9*)', 0x6D580)
local function CObjectEdit_new(...)
    local obj = ffi.new('struct SCObjectEdit[1]')
    CObjectEdit_constructor(obj, ...)
    return obj
end

local GetMaxSizeChar = ffi.cast('const char*(__cdecl*)()', shared.GetAddress(0x6D9B0))

local SCObjectEdit_mt = {
    WorldToScreen = ffi.cast('float(__thiscall*)(SCObjectEdit*, SCVector*, float*)', shared.GetAddress(0x6D640)),
    WorldToScreen = ffi.cast('float(__thiscall*)(SCObjectEdit*, SCVector*, float*)', shared.GetAddress(0x6D640)),
    RenderAxes = ffi.cast('int(__thiscall*)(SCObjectEdit*, SCMatrix*, float)', shared.GetAddress(0x6D740)),
    GetRenderChar = ffi.cast('const char*(__thiscall*)(SCObjectEdit*, BOOL)', shared.GetAddress(0x6D9C0)),
    TryChangeProcessType = ffi.cast('void(__thiscall*)(SCObjectEdit*)', shared.GetAddress(0x6DAC0)),
    SetEditMode = ffi.cast('void(__thiscall*)(SCObjectEdit*, SObjectEditMode)', shared.GetAddress(0x6DC10)),
    ResetMousePos = ffi.cast('void(__thiscall*)(SCObjectEdit*)', shared.GetAddress(0x6DDE0)),
    EnterEditObject = ffi.cast('void(__thiscall*)(SCObjectEdit*, ID, BOOL)', shared.GetAddress(0x6DE40)),
    SendEditEndNotification = ffi.cast('void(__thiscall*)(SCObjectEdit*, int)', shared.GetAddress(0x6E2D0)),
    SendAttachedEditEndNotification = ffi.cast('void(__thiscall*)(SCObjectEdit*, int)', shared.GetAddress(0x6E4E0)),
    Disable = ffi.cast('void(__thiscall*)(SCObjectEdit*, BOOL)', shared.GetAddress(0x6E5E0)),
    RenderControlsForObject = ffi.cast('BOOL(__thiscall*)(SCObjectEdit*, SCMatrix*, float)', shared.GetAddress(0x6E650)),
    ApplyChanges = ffi.cast('void(__thiscall*)(SCObjectEdit*, SObjectEditProcessType, float)', shared.GetAddress(0x6EE80)),
    -- ProcessMouseMove = ...
    MsgProc = ffi.cast('BOOL(__thiscall*)(SCObjectEdit*, int, int, int)', shared.GetAddress(0x6EF70)),
    Render = ffi.cast('void(__thiscall*)(SCObjectEdit*)', shared.GetAddress(0x6F1A0)),
}
SCObjectEdit_mt.__index = SCObjectEdit_mt
ffi.metatype('struct SCObjectEdit', SCObjectEdit_mt)

-- RefObjectEdit = ...

return {
    new = CObjectEdit_new,
    GetMaxSizeChar = GetMaxSizeChar,
}