local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.ffi.cdef[[
#pragma pack(push, 1)
struct SCObjectMaterialText {
    IDirect3DDevice9* m_pDevice;
    ID3DXSprite* m_pSprite;
    ID3DXSprite* m_pSprite_0;
};
typedef struct SCObjectMaterialText SCObjectMaterialText;
#pragma pack(pop)
]]

shared.validate_size('struct SCObjectMaterialText', 0xc)

local CObjectMaterialText_constructor = ffi.cast('void(__thiscall*)(SCObjectMaterialText*, IDirect3DDevice9*)', 0x6C2A0)
local CObjectMaterialText_destructor = ffi.cast('void(__thiscall*)(SCObjectMaterialText*)', 0x6C2C0)
local function CObjectMaterialText_new(...)
    local obj = ffi.gc(ffi.new('struct SCObjectMaterialText[1]'), CObjectMaterialText_destructor)
    CObjectMaterialText_constructor(obj, ...)
    return obj
end

local SCObjectMaterialText_mt = {
    OnResetDevice = ffi.cast('void(__thiscall*)(SCObjectMaterialText*)', shared.GetAddress(0x6C280)),
    OnLostDevice = ffi.cast('void(__thiscall*)(SCObjectMaterialText*)', shared.GetAddress(0x6C250)),
    Create = ffi.cast('IDirect3DTexture9 * (__thiscall*)(SCObjectMaterialText*, const char*, const char*, char, int, int, D3DCOLOR, D3DCOLOR, bool, char)', shared.GetAddress(0x6C2D0)),
}
SCObjectMaterialText_mt.__index = SCObjectMaterialText_mt
ffi.metatype('struct SCObjectMaterialText', SCObjectMaterialText_mt)

local function RefObjectMaterialTextManager() return ffi.cast('SCObjectMaterialText**', shared.GetAddress(0x21A104))[0] end

return {
    new = CObjectMaterialText_new,
    RefObjectMaterialTextManager = RefObjectMaterialTextManager,
}