local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.require 'v037r1.CEntity'
shared.require 'v037r1.CVehicle'
shared.require 'v037r1.CPed'
shared.require 'CMatrix'
shared.require 'CVector'
shared.require 'v037r1.SpecialAction'
shared.require 'v037r1.ControllerState'
shared.require 'v037r1.Animation'
shared.require 'v037r1.AimStuff'
shared.require 'v037r1.Synchronization'

shared.ffi.cdef[[
enum SPlayerState {
    PLAYER_STATE_NONE = 0,
    PLAYER_STATE_ONFOOT = 17,
    PLAYER_STATE_DRIVER = 19,
    PLAYER_STATE_PASSENGER = 18,
    PLAYER_STATE_WASTED = 32,
    PLAYER_STATE_SPAWNED = 33,
};
typedef enum SPlayerState SPlayerState;

enum SUpdateType {
    UPDATE_TYPE_NONE = 0,
    UPDATE_TYPE_ONFOOT = 16,
    UPDATE_TYPE_DRIVER = 17,
    UPDATE_TYPE_PASSENGER = 18,
};
typedef enum SUpdateType SUpdateType;

enum SPlayerStatus {
    PLAYER_STATUS_TIMEOUT = 2,
};
typedef enum SPlayerStatus SPlayerStatus;

#pragma pack(push, 1)
struct SC_161 {
    float real;
    SCVector imag;
};
typedef struct SC_161 SC_161;
#pragma pack(pop)

#pragma pack(push, 1)
struct SC_188 {
    SCVector m_direction;
    TICK m_lastUpdate;
    TICK m_lastLook;
};
typedef struct SC_188 SC_188;
#pragma pack(pop)

#pragma pack(push, 1)
struct SC_191 {
    int x;
    int y;
    int z;
};
typedef struct SC_191 SC_191;
#pragma pack(pop)

#pragma pack(push, 1)
struct SCRemotePlayer {
    SCPed* m_pPed;
    SCVehicle* m_pVehicle;
    NUMBER m_nTeam;
    NUMBER m_nState;
    NUMBER m_nSeatId;
    int field_b;
    BOOL m_bPassengerDriveBy;
    char pad_13[64];
    SCVector m_positionDifference;
    SC_161 m_incarTargetRotation;
    int pad_6f[3];
    SCVector m_onfootTargetPosition;
    SCVector m_onfootTargetSpeed;
    SCVector m_incarTargetPosition;
    SCVector m_incarTargetSpeed;
    ID m_nId;
    ID m_nVehicleId;
    int field_af;
    BOOL m_bDrawLabels;
    BOOL m_bHasJetPack;
    NUMBER m_nSpecialAction;
    int pad_bc[3];
    SOnfootData m_onfootData;
    SIncarData m_incarData;
    STrailerData m_trailerData;
    SPassengerData m_passengerData;
    SAimData m_aimData;
    float m_fReportedArmour;
    float m_fReportedHealth;
    SAnimation m_animation;
    NUMBER m_nUpdateType;
    TICK m_lastUpdate;
    TICK m_lastTimestamp;
    BOOL m_bPerformingCustomAnimation;
    int m_nStatus;
    SC_188 m_head;
    BOOL m_bMarkerState;
    SC_191 m_markerPosition;
    GTAREF m_marker;
};
typedef struct SCRemotePlayer SCRemotePlayer;
#pragma pack(pop)

struct SAim {
    SCVector front;
    SCVector source;
    SCVector sourceBeforeLookBehind;
    SCVector up;
};
typedef struct SAim SAim;

#pragma pack(push, 1)
struct SOnfootData {
    SControllerState m_controllerState;
    SCVector m_position;
    float m_fQuaternion[4];
    unsigned char m_nHealth;
    unsigned char m_nArmor;
    unsigned char m_nCurrentWeapon;
    unsigned char m_nSpecialAction;
    SCVector m_speed;
    SCVector m_surfingOffset;
    ID m_nSurfingVehicleId;
    SAnimation m_animation;
};
typedef struct SOnfootData SOnfootData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SIncarData {
    ID m_nVehicle;
    SControllerState m_controllerState;
    float m_fQuaternion[4];
    SCVector m_position;
    SCVector m_speed;
    float m_fHealth;
    unsigned char m_nDriverHealth;
    unsigned char m_nDriverArmor;
    unsigned char m_nCurrentWeapon;
    bool m_bSirenEnabled;
    bool m_bLandingGear;
    ID m_nTrailerId;
    union {
        short unsigned int m_aHydraThrustAngle[2]; float m_fTrainSpeed;
    };
};
typedef struct SIncarData SIncarData;
#pragma pack(pop)

enum SWeaponState {
    WS_NO_BULLETS = 0,
    WS_LAST_BULLET = 1,
    WS_MORE_BULLETS = 2,
    WS_RELOADING = 3,
};
typedef enum SWeaponState SWeaponState;

#pragma pack(push, 1)
struct SAimData {
    unsigned char m_nCameraMode;
    SCVector m_aimf1;
    SCVector m_aimPos;
    float m_fAimZ;
    unsigned char m_nCameraExtZoom;
    unsigned char m_nWeaponState;
    char m_nAspectRatio;
};
typedef struct SAimData SAimData;
#pragma pack(pop)

#pragma pack(push, 1)
struct STrailerData {
    ID m_nId;
    SCVector m_position;
    float m_fQuaternion[4];
    SCVector m_speed;
    SCVector m_turnSpeed;
};
typedef struct STrailerData STrailerData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SPassengerData {
    ID m_nVehicleId;
    unsigned char m_nSeatId;
    unsigned char m_nCurrentWeapon;
    unsigned char m_nHealth;
    unsigned char m_nArmor;
    SControllerState m_controllerState;
    SCVector m_position;
};
typedef struct SPassengerData SPassengerData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SUnoccupiedData {
    ID m_nVehicleId;
    unsigned char m_nSeatId;
    SCVector m_roll;
    SCVector m_direction;
    SCVector m_position;
    SCVector m_speed;
    SCVector m_turnSpeed;
    float m_fHealth;
};
typedef struct SUnoccupiedData SUnoccupiedData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SBulletData {
    unsigned char m_nTargetType;
    ID m_nTargetId;
    SCVector m_origin;
    SCVector m_target;
    SCVector m_center;
    unsigned char m_nWeapon;
};
typedef struct SBulletData SBulletData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SSpectatorData {
    SControllerState m_controllerState;
    SCVector m_position;
};
typedef struct SSpectatorData SSpectatorData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SStatsData {
    int m_nMoney;
    int m_nDrunkLevel;
};
typedef struct SStatsData SStatsData;
#pragma pack(pop)
]]

shared.validate_size('struct SC_161', 0x10)
shared.validate_size('struct SC_188', 0x14)
shared.validate_size('struct SC_191', 0xc)
shared.validate_size('struct SCRemotePlayer', 0x1fd)
shared.validate_size('struct SAim', 0x30)
shared.validate_size('struct SOnfootData', 0x44)
shared.validate_size('struct SIncarData', 0x3f)
shared.validate_size('struct SAimData', 0x1f)
shared.validate_size('struct STrailerData', 0x36)
shared.validate_size('struct SPassengerData', 0x18)
shared.validate_size('struct SUnoccupiedData', 0x43)
shared.validate_size('struct SBulletData', 0x28)
shared.validate_size('struct SSpectatorData', 0x12)
shared.validate_size('struct SStatsData', 0x8)

local CRemotePlayer_constructor = ffi.cast('void(__thiscall*)(SCRemotePlayer*)', 0x12E20)
local CRemotePlayer_destructor = ffi.cast('void(__thiscall*)(SCRemotePlayer*)', 0x12EA0)
local function CRemotePlayer_new(...)
    local obj = ffi.gc(ffi.new('struct SCRemotePlayer[1]'), CRemotePlayer_destructor)
    CRemotePlayer_constructor(obj, ...)
    return obj
end

local SCRemotePlayer_mt = {
    Spawn = ffi.cast('BOOL(__thiscall*)(SCRemotePlayer*, int, int, SCVector*, float, D3DCOLOR, char)', shared.GetAddress(0x13890)),
    ProcessHead = ffi.cast('void(__thiscall*)(SCRemotePlayer*)', shared.GetAddress(0x10EA0)),
    SetMarkerState = ffi.cast('void(__thiscall*)(SCRemotePlayer*, BOOL)', shared.GetAddress(0x10FF0)),
    SetMarkerPosition = ffi.cast('void(__thiscall*)(SCRemotePlayer*, int, int, int)', shared.GetAddress(0x11030)),
    Surfing = ffi.cast('BOOL(__thiscall*)(SCRemotePlayer*)', shared.GetAddress(0x110D0)),
    SurfingOnObject = ffi.cast('BOOL(__thiscall*)(SCRemotePlayer*)', shared.GetAddress(0x11100)),
    ProcessSurfing = ffi.cast('void(__thiscall*)(SCRemotePlayer*)', shared.GetAddress(0x11130)),
    OnEnterVehicle = ffi.cast('void(__thiscall*)(SCRemotePlayer*)', shared.GetAddress(0x112D0)),
    OnExitVehicle = ffi.cast('void(__thiscall*)(SCRemotePlayer*)', shared.GetAddress(0x113A0)),
    ProcessSpecialAction = ffi.cast('void(__thiscall*)(SCRemotePlayer*)', shared.GetAddress(0x113F0)),
    UpdateOnfootSpeedAndPosition = ffi.cast('void(__thiscall*)(SCRemotePlayer*)', shared.GetAddress(0x11840)),
    UpdateOnfootRotation = ffi.cast('void(__thiscall*)(SCRemotePlayer*)', shared.GetAddress(0x11990)),
    SetOnfootTargetSpeedAndPosition = ffi.cast('void(__thiscall*)(SCRemotePlayer*, SCVector*, SCVector*)', shared.GetAddress(0x11A60)),
    UpdateIncarSpeedAndPosition = ffi.cast('void(__thiscall*)(SCRemotePlayer*)', shared.GetAddress(0x11AC0)),
    UpdateIncarRotation = ffi.cast('void(__thiscall*)(SCRemotePlayer*)', shared.GetAddress(0x11DA0)),
    SetIncarTargetSpeedAndPosition = ffi.cast('void(__thiscall*)(SCRemotePlayer*, SCMatrix*, SCVector*, SCVector*)', shared.GetAddress(0x11F10)),
    UpdateTrain = ffi.cast('void(__thiscall*)(SCRemotePlayer*, SCMatrix*, SCVector*, float)', shared.GetAddress(0x11F80)),
    Update = ffi.cast('void(__thiscall*)(SCRemotePlayer*, SAimData*)', shared.GetAddress(0x12080)),
    Update = ffi.cast('void(__thiscall*)(SCRemotePlayer*, SAimData*)', shared.GetAddress(0x12080)),
    Update = ffi.cast('void(__thiscall*)(SCRemotePlayer*, SAimData*)', shared.GetAddress(0x12080)),
    ResetData = ffi.cast('void(__thiscall*)(SCRemotePlayer*)', shared.GetAddress(0x12830)),
    GetDistanceToPlayer = ffi.cast('float(__thiscall*)(SCRemotePlayer*, SCRemotePlayer*)', shared.GetAddress(0x12930)),
    GetDistanceToLocalPlayer = ffi.cast('float(__thiscall*)(SCRemotePlayer*)', shared.GetAddress(0x129A0)),
    SetColor = ffi.cast('void(__thiscall*)(SCRemotePlayer*, D3DCOLOR)', shared.GetAddress(0x129D0)),
    GetColorAsRGBA = ffi.cast('D3DCOLOR(__thiscall*)(SCRemotePlayer*)', shared.GetAddress(0x129F0)),
    GetColorAsARGB = ffi.cast('D3DCOLOR(__thiscall*)(SCRemotePlayer*)', shared.GetAddress(0x12A00)),
    EnterVehicle = ffi.cast('void(__thiscall*)(SCRemotePlayer*, ID, BOOL)', shared.GetAddress(0x12A20)),
    ExitVehicle = ffi.cast('void(__thiscall*)(SCRemotePlayer*)', shared.GetAddress(0x12AB0)),
    ChangeState = ffi.cast('void(__thiscall*)(SCRemotePlayer*, char, char)', shared.GetAddress(0x12AE0)),
    GetStatus = ffi.cast('int(__thiscall*)(SCRemotePlayer*)', shared.GetAddress(0x12BA0)),
    Update = ffi.cast('void(__thiscall*)(SCRemotePlayer*, SAimData*)', shared.GetAddress(0x12080)),
    Process = ffi.cast('void(__thiscall*)(SCRemotePlayer*)', shared.GetAddress(0x12EF0)),
    Update = ffi.cast('void(__thiscall*)(SCRemotePlayer*, SAimData*)', shared.GetAddress(0x12080)),
    Update = ffi.cast('void(__thiscall*)(SCRemotePlayer*, SAimData*)', shared.GetAddress(0x12080)),
    Update = ffi.cast('void(__thiscall*)(SCRemotePlayer*, SAimData*)', shared.GetAddress(0x12080)),
    Remove = ffi.cast('void(__thiscall*)(SCRemotePlayer*)', shared.GetAddress(0x13C60)),
    Kill = ffi.cast('void(__thiscall*)(SCRemotePlayer*)', shared.GetAddress(0x13CA0)),
    Chat = ffi.cast('void(__thiscall*)(SCRemotePlayer*, const char*)', shared.GetAddress(0x13D30)),
    DoesExist = ffi.cast('BOOL(__thiscall*)(SCRemotePlayer*)', shared.GetAddress(0x1080)),
}
SCRemotePlayer_mt.__index = SCRemotePlayer_mt
ffi.metatype('struct SCRemotePlayer', SCRemotePlayer_mt)

local AimStuff = {}

-- RefLocalPlayerCameraExtZoom = ...
-- RefLocalPlayerAspectRatio = ...
-- RefInternalCameraExtZoom = ...
-- RefInternalAspectRatio = ...
-- ArrayCameraExtZoom = ...
-- ArrayAspectRatio = ...
-- ArrayCameraMode = ...
-- RefInternalCameraMode = ...
-- RefLocalPlayerAim = ...
-- ArrayPlayerAim = ...
-- RefInternalAim = ...
-- UpdateCameraExtZoomAndAspectRatio = ...
-- ApplyCameraExtZoomAndAspectRatio = ...
-- SetCameraExtZoomAndAspectRatio = ...
-- GetAspectRatio = ...
-- GetCameraExtZoom = ...
-- ApplyCameraExtZoomAndAspectRatio = ...
-- SetCameraMode = ...
-- GetCameraMode = ...
-- GetCameraMode = ...
-- Initialize = ...
-- UpdateAim = ...
-- ApplyAim = ...
-- GetAim = ...
-- SetAim = ...
-- ApplyAim = ...
-- GetAim = ...
local Synchronization = {}

-- CompressAspectRatio = ...
-- DecompressAspectRatio = ...
-- CompressCameraExtZoom = ...
-- DecompressCameraExtZoom = ...

return {
    new = CRemotePlayer_new,
    AimStuff = AimStuff,
    Synchronization = Synchronization,
}