local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.ffi.cdef[[
enum {
    MAX_EXCEPTIONS = 9,
};
]]

local function RefCount() return ffi.cast('int*', shared.GetAddress(0x1118B0))[0] end
local function RefContextRecord() return ffi.cast('void**', shared.GetAddress(0x10D8A8))[0] end
local function ArrayCrashDialogText() return ffi.cast('char* ', shared.GetAddress(0x10D8B0)) end
local Print = ffi.cast('BOOL(__stdcall*)(int, void*, const char*)', shared.GetAddress(0x5CED0))
local SendCrashReport = ffi.cast('void(__cdecl*)()', shared.GetAddress(0x5CCC0))
local CrashDialogProc = ffi.cast('BOOL(__stdcall*)(void*, unsigned int, unsigned int, long)', shared.GetAddress(0x5CD90))
local ConstructCrashDialogText = ffi.cast('void(__cdecl*)(BOOL)', shared.GetAddress(0x5CAD0))
local Handler = ffi.cast('long(__stdcall*)(void*)', shared.GetAddress(0x5CE90))

return {
    RefCount = RefCount,
    RefContextRecord = RefContextRecord,
    ArrayCrashDialogText = ArrayCrashDialogText,
    Print = Print,
    SendCrashReport = SendCrashReport,
    CrashDialogProc = CrashDialogProc,
    ConstructCrashDialogText = ConstructCrashDialogText,
    Handler = Handler,
}