local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.ffi.cdef[[
#pragma pack(push, 2)
struct SOpcodeInfo {
    short unsigned int m_wOpCode;
    char m_szParams[16];
};
typedef struct SOpcodeInfo SOpcodeInfo;
#pragma pack(pop)
]]

shared.validate_size('struct SOpcodeInfo', 0x12)

local function RefThread() return ffi.cast('SCRunningScript**', shared.GetAddress(0x216048))[0] end
local function ArrayBuffer() return ffi.cast('unsigned char* ', shared.GetAddress(0x215F48)) end
local function RefLastUsedOpcode() return ffi.cast('unsigned long*', shared.GetAddress(0x21604C))[0] end
local function ArrayThreadLocals() return ffi.cast('unsigned long** ', shared.GetAddress(0x215F00)) end
-- RefLocalDebug = ...
local function RefProcessOneCommand() return ffi.cast('SProcessOneCommandFn*', shared.GetAddress(0x1023C4))[0] end
local Initialize = ffi.cast('void(__cdecl*)()', shared.GetAddress(0xABF10))
local ExecBuffer = ffi.cast('int(__cdecl*)()', shared.GetAddress(0xABC90))
-- FunctionProcessCommand = ...

return {
    RefThread = RefThread,
    ArrayBuffer = ArrayBuffer,
    RefLastUsedOpcode = RefLastUsedOpcode,
    ArrayThreadLocals = ArrayThreadLocals,
    RefProcessOneCommand = RefProcessOneCommand,
    Initialize = Initialize,
    ExecBuffer = ExecBuffer,
}