local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.require 'v037r1.CEntity'
shared.require 'v037r1.CVehicle'
shared.require 'v037r1.KeyStuff'
shared.require 'CMatrix'
shared.require 'CVector'
shared.require 'v037r1.CCamera'

local function RefCamera() return ffi.cast('SCCamera**', shared.GetAddress(0x13BA7C))[0] end
local function RefVehicle() return ffi.cast('SCVehicle**', shared.GetAddress(0x13BB64))[0] end
local function RefControls() return ffi.cast('SCPad**', shared.GetAddress(0x13BA78))[0] end
local function RefInitialized() return ffi.cast('BOOL*', shared.GetAddress(0x13BB60))[0] end
local function RefSelectedModel() return ffi.cast('int*', shared.GetAddress(0x1014B4))[0] end
local ResetVehicle = ffi.cast('void(__cdecl*)()', shared.GetAddress(0x99710))
local Process = ffi.cast('void(__cdecl*)()', shared.GetAddress(0x99AD0))
local KeyStuff = {}

-- RefLocalPlayerKeys = ...
-- ArrayPlayerKeys = ...
-- RefInternalKeys = ...
-- RefDriveByLeft = ...
-- RefDriveByRight = ...
-- RefSavedDriveByLeft = ...
-- RefSavedDriveByRight = ...
-- Initialize = ...
-- UpdateKeys = ...
-- ApplyKeys = ...
-- SetKeys = ...
-- ApplyKeys = ...
-- GetInternalKeys = ...
-- GetKeys = ...
-- GetKeys = ...
-- ResetKeys = ...
-- ResetInternalKeys = ...

return {
    RefCamera = RefCamera,
    RefVehicle = RefVehicle,
    RefControls = RefControls,
    RefInitialized = RefInitialized,
    RefSelectedModel = RefSelectedModel,
    ResetVehicle = ResetVehicle,
    Process = Process,
    KeyStuff = KeyStuff,
}