local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.require 'CVector'

shared.ffi.cdef[[
struct SAim {
    SCVector front;
    SCVector source;
    SCVector sourceBeforeLookBehind;
    SCVector up;
};
typedef struct SAim SAim;
]]

shared.validate_size('struct SAim', 0x30)

local function RefLocalPlayerCameraExtZoom() return ffi.cast('float*', shared.GetAddress(0x12FBA0))[0] end
local function RefLocalPlayerAspectRatio() return ffi.cast('float*', shared.GetAddress(0x132758))[0] end
local function RefInternalCameraExtZoom() return ffi.cast('float**', shared.GetAddress(0xF159C))[0] end
local function RefInternalAspectRatio() return ffi.cast('float**', shared.GetAddress(0xF1598))[0] end
local function ArrayCameraExtZoom() return ffi.cast('float* ', shared.GetAddress(0x12FC80)) end
local function ArrayAspectRatio() return ffi.cast('float* ', shared.GetAddress(0x132788)) end
local function ArrayCameraMode() return ffi.cast('char* ', shared.GetAddress(0x12FBA8)) end
local function RefInternalCameraMode() return ffi.cast('char**', shared.GetAddress(0x10153C))[0] end
local function RefLocalPlayerAim() return ffi.cast('SAim*', shared.GetAddress(0x12FFC8))[0] end
local function ArrayPlayerAim() return ffi.cast('SAim* ', shared.GetAddress(0x12FFF8)) end
local function RefInternalAim() return ffi.cast('SAim**', shared.GetAddress(0xF1590))[0] end
local UpdateCameraExtZoomAndAspectRatio = ffi.cast('void(__stdcall*)()', shared.GetAddress(0x98160))
local ApplyCameraExtZoomAndAspectRatio = ffi.cast('void(__stdcall*)(NUMBER)', shared.GetAddress(0x981F0))
local SetCameraExtZoomAndAspectRatio = ffi.cast('void(__stdcall*)(NUMBER, float, float)', shared.GetAddress(0x981A0))
local GetAspectRatio = ffi.cast('float(__stdcall*)()', shared.GetAddress(0x981C0))
local GetCameraExtZoom = ffi.cast('float(__stdcall*)()', shared.GetAddress(0x981D0))
local ApplyCameraExtZoomAndAspectRatio = ffi.cast('void(__stdcall*)(NUMBER)', shared.GetAddress(0x981F0))
local SetCameraMode = ffi.cast('void(__stdcall*)(char, NUMBER)', shared.GetAddress(0x98230))
local GetCameraMode = ffi.cast('char(__stdcall*)(NUMBER)', shared.GetAddress(0x98250))
local GetCameraMode = ffi.cast('char(__stdcall*)(NUMBER)', shared.GetAddress(0x98250))
local Initialize = ffi.cast('void(__stdcall*)()', shared.GetAddress(0x98270))
local UpdateAim = ffi.cast('void(__stdcall*)()', shared.GetAddress(0x982E0))
local ApplyAim = ffi.cast('void(__stdcall*)()', shared.GetAddress(0x98300))
local GetAim = ffi.cast('SAim * (__stdcall*)()', shared.GetAddress(0x98320))
local SetAim = ffi.cast('void(__stdcall*)(int, const SAim*)', shared.GetAddress(0x98330))
local ApplyAim = ffi.cast('void(__stdcall*)()', shared.GetAddress(0x98300))
local GetAim = ffi.cast('SAim * (__stdcall*)()', shared.GetAddress(0x98320))

return {
    RefLocalPlayerCameraExtZoom = RefLocalPlayerCameraExtZoom,
    RefLocalPlayerAspectRatio = RefLocalPlayerAspectRatio,
    RefInternalCameraExtZoom = RefInternalCameraExtZoom,
    RefInternalAspectRatio = RefInternalAspectRatio,
    ArrayCameraExtZoom = ArrayCameraExtZoom,
    ArrayAspectRatio = ArrayAspectRatio,
    ArrayCameraMode = ArrayCameraMode,
    RefInternalCameraMode = RefInternalCameraMode,
    RefLocalPlayerAim = RefLocalPlayerAim,
    ArrayPlayerAim = ArrayPlayerAim,
    RefInternalAim = RefInternalAim,
    UpdateCameraExtZoomAndAspectRatio = UpdateCameraExtZoomAndAspectRatio,
    ApplyCameraExtZoomAndAspectRatio = ApplyCameraExtZoomAndAspectRatio,
    SetCameraExtZoomAndAspectRatio = SetCameraExtZoomAndAspectRatio,
    GetAspectRatio = GetAspectRatio,
    GetCameraExtZoom = GetCameraExtZoom,
    ApplyCameraExtZoomAndAspectRatio = ApplyCameraExtZoomAndAspectRatio,
    SetCameraMode = SetCameraMode,
    GetCameraMode = GetCameraMode,
    GetCameraMode = GetCameraMode,
    Initialize = Initialize,
    UpdateAim = UpdateAim,
    ApplyAim = ApplyAim,
    GetAim = GetAim,
    SetAim = SetAim,
    ApplyAim = ApplyAim,
    GetAim = GetAim,
}