local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.require 'CRect'

shared.ffi.cdef[[
struct SCFont;
typedef struct SCFont SCFont;

#pragma pack(push, 1)
struct SCFonts {
    SCFont* m_pFont;
    SCFont* m_pLittleFont;
    SCFont* m_pShadow;
    SCFont* m_pLittleShadow;
    SCFont* m_pLicensePlateFont;
    ID3DXSprite* m_pDefaultSprite;
    IDirect3DDevice9* m_pDevice;
    char* m_szTempBuffer;
};
typedef struct SCFonts SCFonts;
#pragma pack(pop)
]]

shared.validate_size('struct SCFonts', 0x20)

local CFonts_constructor = ffi.cast('void(__thiscall*)(SCFonts*, IDirect3DDevice9*)', 0x67410)
local CFonts_destructor = ffi.cast('void(__thiscall*)(SCFonts*)', 0x66A20)
local function CFonts_new(...)
    local obj = ffi.gc(ffi.new('struct SCFonts[1]'), CFonts_destructor)
    CFonts_constructor(obj, ...)
    return obj
end

local SCFonts_mt = {
    OnLostDevice = ffi.cast('void(__thiscall*)(SCFonts*)', shared.GetAddress(0x66AA0)),
    OnResetDevice = ffi.cast('void(__thiscall*)(SCFonts*)', shared.GetAddress(0x66AE0)),
    GetTextScreenSize = ffi.cast('void(__thiscall*)(SCFonts*, void*, const char*, unsigned long)', shared.GetAddress(0x66B20)),
    GetLittleTextScreenSize = ffi.cast('void(__thiscall*)(SCFonts*, void*, const char*, unsigned long)', shared.GetAddress(0x66BD0)),
    DrawText = ffi.cast('void(__thiscall*)(SCFonts*, ID3DXSprite*, const char*, SCRect, D3DCOLOR, BOOL)', shared.GetAddress(0x66C80)),
    DrawLittleText = ffi.cast('void(__thiscall*)(SCFonts*, ID3DXSprite*, const char*, SCRect, int, D3DCOLOR, BOOL)', shared.GetAddress(0x66E00)),
    DrawLicensePlateText = ffi.cast('void(__thiscall*)(SCFonts*, const char*, SCRect, D3DCOLOR)', shared.GetAddress(0x66F70)),
    Reset = ffi.cast('void(__thiscall*)(SCFonts*)', shared.GetAddress(0x67200)),
}
SCFonts_mt.__index = SCFonts_mt
ffi.metatype('struct SCFonts', SCFonts_mt)

local function RefFontRenderer() return ffi.cast('SCFonts**', shared.GetAddress(0x21A0FC))[0] end

return {
    new = CFonts_new,
    RefFontRenderer = RefFontRenderer,
}