local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.ffi.cdef[[
#pragma pack(push, 1)
struct SC_55 {
    float left;
    float bottom;
    float right;
    float top;
};
typedef struct SC_55 SC_55;
#pragma pack(pop)

#pragma pack(push, 1)
struct SGangZone {
    SC_55 m_rect;
    D3DCOLOR m_color;
    D3DCOLOR m_altColor;
};
typedef struct SGangZone SGangZone;
#pragma pack(pop)

enum {
    MAX_GANGZONES = 1024,
};

#pragma pack(push, 1)
struct SCGangZonePool {
    SGangZone* m_pObject[1024];
    BOOL m_bNotEmpty[1024];
};
typedef struct SCGangZonePool SCGangZonePool;
#pragma pack(pop)
]]

shared.validate_size('struct SC_55', 0x10)
shared.validate_size('struct SGangZone', 0x18)
shared.validate_size('struct SCGangZonePool', 0x2000)

local CGangZonePool_constructor = ffi.cast('void(__thiscall*)(SCGangZonePool*)', 0x2110)
local CGangZonePool_destructor = ffi.cast('void(__thiscall*)(SCGangZonePool*)', 0x2140)
local function CGangZonePool_new(...)
    local obj = ffi.gc(ffi.new('struct SCGangZonePool[1]'), CGangZonePool_destructor)
    CGangZonePool_constructor(obj, ...)
    return obj
end

local SCGangZonePool_mt = {
    Create = ffi.cast('void(__thiscall*)(SCGangZonePool*, ID, float, float, float, float, D3DCOLOR)', shared.GetAddress(0x2170)),
    StartFlashing = ffi.cast('void(__thiscall*)(SCGangZonePool*, ID, D3DCOLOR)', shared.GetAddress(0x21F0)),
    StopFlashing = ffi.cast('void(__thiscall*)(SCGangZonePool*, ID)', shared.GetAddress(0x2210)),
    Delete = ffi.cast('void(__thiscall*)(SCGangZonePool*, ID)', shared.GetAddress(0x2230)),
    Draw = ffi.cast('void(__thiscall*)(SCGangZonePool*)', shared.GetAddress(0x2260)),
}
SCGangZonePool_mt.__index = SCGangZonePool_mt
ffi.metatype('struct SCGangZonePool', SCGangZonePool_mt)

return {
    new = CGangZonePool_new,
}