local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.ffi.cdef[[
enum {
    RECEIVE_BUFFER_SIZE = 4096,
};

enum SRequestType {
    GET = 1,
    POST = 2,
    HEAD = 3,
};
typedef enum SRequestType SRequestType;

#pragma pack(push, 1)
struct SRequest {
    short unsigned int m_nPort;
    int m_nType;
    char* m_szHost;
    char* m_szFile;
    char* m_szData;
    char* m_szReferer;
};
typedef struct SRequest SRequest;
#pragma pack(pop)

enum SContentType {
    CONTENT_UNKNOWN = 0,
    CONTENT_TEXT = 1,
    CONTENT_HTML = 2,
};
typedef enum SContentType SContentType;

#pragma pack(push, 1)
struct SResponse {
    char* m_szHeader;
    char* m_szResponse;
    unsigned int m_nHeaderLen;
    unsigned int m_nResponseLen;
    unsigned int m_nResponseCode;
    unsigned int m_nContentType;
};
typedef struct SResponse SResponse;
#pragma pack(pop)

enum SErrorCode {
    ERROR_SUCCESS = 0,
    ERROR_BAD_HOST = 1,
    ERROR_NO_SOCKET = 2,
    ERROR_CANNOT_CONNECT = 3,
    ERROR_CANNOT_WRITE = 4,
    ERROR_TOO_BIG_CONTENT = 5,
    ERROR_INCORRECT_RESPONSE = 6,
};
typedef enum SErrorCode SErrorCode;

#pragma pack(push, 1)
struct SCHttpClient {
    int m_nSocket;
    SRequest m_request;
    SResponse m_response;
    SErrorCode m_error;
};
typedef struct SCHttpClient SCHttpClient;
#pragma pack(pop)
]]

shared.validate_size('struct SRequest', 0x16)
shared.validate_size('struct SResponse', 0x18)
shared.validate_size('struct SCHttpClient', 0x36)

local CHttpClient_constructor = ffi.cast('void(__thiscall*)(SCHttpClient*)', 0x22D0)
local CHttpClient_destructor = ffi.cast('void(__thiscall*)(SCHttpClient*)', 0x2330)
local function CHttpClient_new(...)
    local obj = ffi.gc(ffi.new('struct SCHttpClient[1]'), CHttpClient_destructor)
    CHttpClient_constructor(obj, ...)
    return obj
end

local SCHttpClient_mt = {
    GetHeaderValue = ffi.cast('bool(__thiscall*)(SCHttpClient*, const char*, char*, int)', shared.GetAddress(0x23A0)),
    InitializeRequest = ffi.cast('void(__thiscall*)(SCHttpClient*, int, const char*, const char*, const char*)', shared.GetAddress(0x24A0)),
    HandleEntity = ffi.cast('void(__thiscall*)(SCHttpClient*)', shared.GetAddress(0x2670)),
    Connect = ffi.cast('bool(__thiscall*)(SCHttpClient*, const char*, int)', shared.GetAddress(0x2990)),
    Process = ffi.cast('void(__thiscall*)(SCHttpClient*)', shared.GetAddress(0x2A50)),
    Disconnect = ffi.cast('void(__thiscall*)(SCHttpClient*)', shared.GetAddress(0x2430)),
    ProcessUrl = ffi.cast('SErrorCode(__thiscall*)(SCHttpClient*, int, const char*, const char*, const char*)', shared.GetAddress(0x2C30)),
    Send = ffi.cast('bool(__thiscall*)(SCHttpClient*, const char*)', shared.GetAddress(0x2440)),
    Receive = ffi.cast('int(__thiscall*)(SCHttpClient*, char*, int)', shared.GetAddress(0x2480)),
}
SCHttpClient_mt.__index = SCHttpClient_mt
ffi.metatype('struct SCHttpClient', SCHttpClient_mt)

return {
    new = CHttpClient_new,
}