local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.require 'CVector'

shared.ffi.cdef[[
#pragma pack(push, 1)
struct STextLabel {
    char* m_pText;
    D3DCOLOR m_color;
    SCVector m_position;
    float m_fDrawDistance;
    bool m_bBehindWalls;
    ID m_nAttachedToPlayer;
    ID m_nAttachedToVehicle;
};
typedef struct STextLabel STextLabel;
#pragma pack(pop)

enum {
    MAX_TEXT_LABELS = 2048,
};

#pragma pack(push, 1)
struct SCLabelPool {
    STextLabel m_object[2048];
    BOOL m_bNotEmpty[2048];
};
typedef struct SCLabelPool SCLabelPool;
#pragma pack(pop)
]]

shared.validate_size('struct STextLabel', 0x1d)
shared.validate_size('struct SCLabelPool', 0x10800)

local CLabelPool_constructor = ffi.cast('void(__thiscall*)(SCLabelPool*)', 0x1180)
local CLabelPool_destructor = ffi.cast('void(__thiscall*)(SCLabelPool*)', 0x15D0)
local function CLabelPool_new(...)
    local obj = ffi.gc(ffi.new('struct SCLabelPool[1]'), CLabelPool_destructor)
    CLabelPool_constructor(obj, ...)
    return obj
end

local SCLabelPool_mt = {
    Create = ffi.cast('void(__thiscall*)(SCLabelPool*, ID, const char*, D3DCOLOR, SCVector, float, bool, ID, ID)', shared.GetAddress(0x11C0)),
    Delete = ffi.cast('BOOL(__thiscall*)(SCLabelPool*, ID)', shared.GetAddress(0x12D0)),
    Draw = ffi.cast('void(__thiscall*)(SCLabelPool*)', shared.GetAddress(0x1340)),
}
SCLabelPool_mt.__index = SCLabelPool_mt
ffi.metatype('struct SCLabelPool', SCLabelPool_mt)

return {
    new = CLabelPool_new,
}