local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.ffi.cdef[[
enum {
    DEFAULT_PLATE_TEXT_COLOR = -297515920,
    DEFAULT_PLATE_BG_COLOR = -4278616,
};

#pragma pack(push, 1)
struct SCLicensePlate {
    IDirect3DDevice9* m_pDevice;
    ID3DXRenderToSurface* m_pRenderer;
    IDirect3DTexture9* m_pTexture;
    IDirect3DSurface9* m_pSurface;
    unsigned int m_displayMode[4];
    IDirect3DTexture9* m_pDefaultPlate;
};
typedef struct SCLicensePlate SCLicensePlate;
#pragma pack(pop)
]]

shared.validate_size('struct SCLicensePlate', 0x24)

local CLicensePlate_constructor = ffi.cast('void(__thiscall*)(SCLicensePlate*, IDirect3DDevice9*)', 0x692D0)
local CLicensePlate_destructor = ffi.cast('void(__thiscall*)(SCLicensePlate*)', 0x69300)
local function CLicensePlate_new(...)
    local obj = ffi.gc(ffi.new('struct SCLicensePlate[1]'), CLicensePlate_destructor)
    CLicensePlate_constructor(obj, ...)
    return obj
end

local SCLicensePlate_mt = {
    OnLostDevice = ffi.cast('void(__thiscall*)(SCLicensePlate*)', shared.GetAddress(0x690D0)),
    OnResetDevice = ffi.cast('void(__thiscall*)(SCLicensePlate*)', shared.GetAddress(0x69120)),
    Create = ffi.cast('IDirect3DTexture9 * (__thiscall*)(SCLicensePlate*, const char*)', shared.GetAddress(0x691A0)),
}
SCLicensePlate_mt.__index = SCLicensePlate_mt
ffi.metatype('struct SCLicensePlate', SCLicensePlate_mt)

local function RefLicensePlateManager() return ffi.cast('SCLicensePlate**', shared.GetAddress(0x21A100))[0] end

return {
    new = CLicensePlate_new,
    RefLicensePlateManager = RefLicensePlateManager,
}