local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.require 'v037r1.CEntity'
shared.require 'v037r1.CVehicle'
shared.require 'v037r1.CPed'
shared.require 'v037r1.CPlayerPool'
shared.require 'v037r1.CObject'
shared.require 'CMatrix'
shared.require 'CVector'
shared.require 'v037r1.CLabelPool'
shared.require 'v037r1.CActorPool'
shared.require 'v037r1.CActor'
shared.require 'v037r1.CObjectPool'
shared.require 'v037r1.CMenuPool'
shared.require 'v037r1.CMenu'
shared.require 'v037r1.CTextDrawPool'
shared.require 'v037r1.CTextDraw'
shared.require 'v037r1.CGangZonePool'
shared.require 'v037r1.CPickupPool'
shared.require 'v037r1.CVehiclePool'
shared.require 'v037r1.CLocalPlayer'
shared.require 'v037r1.CPlayerInfo'
shared.require 'v037r1.CRemotePlayer'
shared.require 'v037r1.SpecialAction'
shared.require 'v037r1.ControllerState'
shared.require 'v037r1.Animation'
shared.require 'v037r1.AimStuff'
shared.require 'v037r1.Synchronization'

shared.ffi.cdef[[
enum SMarkersMode {
    MARKERS_MODE_OFF = 0,
    MARKERS_MODE_GLOBAL = 1,
    MARKERS_MODE_STREAMED = 2,
};
typedef enum SMarkersMode SMarkersMode;

enum SGameMode {
    GAME_MODE_WAITCONNECT = 9,
    GAME_MODE_CONNECTING = 13,
    GAME_MODE_CONNECTED = 14,
    GAME_MODE_WAITJOIN = 15,
    GAME_MODE_RESTARTING = 18,
};
typedef enum SGameMode SGameMode;

enum {
    NETMODE_STATS_UPDATE_DELAY = 1000,
    NETMODE_INCAR_SENDRATE = 30,
    NETMODE_ONFOOT_SENDRATE = 30,
    NETMODE_FIRING_SENDRATE = 30,
    LANMODE_INCAR_SENDRATE = 15,
    LANMODE_ONFOOT_SENDRATE = 15,
    NETMODE_SEND_MULTIPLIER = 2,
    NETMODE_AIM_UPDATE_DELAY = 500,
    NETMODE_HEAD_UPDATE_DELAY = 1000,
    NETMODE_TARGET_UPDATE_DELAY = 100,
    NETMODE_PLAYERS_UPDATE_DELAY = 3000,
};

#pragma pack(push, 1)
struct SPools {
    SCActorPool* m_pActor;
    SCObjectPool* m_pObject;
    SCGangZonePool* m_pGangZone;
    SCLabelPool* m_pLabel;
    SCTextDrawPool* m_pTextDraw;
    SCMenuPool* m_pMenu;
    SCPlayerPool* m_pPlayer;
    SCVehiclePool* m_pVehicle;
    SCPickupPool* m_pPickup;
};
typedef struct SPools SPools;
#pragma pack(pop)

#pragma pack(push, 1)
struct SSettings {
    bool m_bUseCJWalk;
    unsigned int m_nDeadDropsMoney;
    float m_fWorldBoundaries[4];
    bool m_bAllowWeapons;
    float m_fGravity;
    bool m_bEnterExit;
    BOOL m_bVehicleFriendlyFire;
    bool m_bHoldTime;
    bool m_bInstagib;
    bool m_bZoneNames;
    bool m_bFriendlyFire;
    BOOL m_bClassesAvailable;
    float m_fNameTagsDrawDist;
    bool m_bManualVehicleEngineAndLight;
    unsigned char m_nWorldTimeHour;
    unsigned char m_nWorldTimeMinute;
    unsigned char m_nWeather;
    bool m_bNoNametagsBehindWalls;
    int m_nPlayerMarkersMode;
    float m_fChatRadius;
    bool m_bNameTags;
    bool m_bLtdChatRadius;
};
typedef struct SSettings SSettings;
#pragma pack(pop)

#pragma pack(push, 1)
struct SCNetGame {
    char pad_0[32];
    char m_szHostAddress[257];
    char m_szHostname[257];
    bool m_bDisableCollision;
    bool m_bUpdateCameraTarget;
    bool m_bNametagStatus;
    int m_nPort;
    BOOL m_bLanMode;
    GTAREF m_aMapIcons[100];
    int m_nGameState;
    TICK m_lastConnectAttempt;
    SSettings* m_pSettings;
    RakClientInterface* m_pRakClient;
    SPools* m_pPools;
};
typedef struct SCNetGame SCNetGame;
#pragma pack(pop)

struct SAim {
    SCVector front;
    SCVector source;
    SCVector sourceBeforeLookBehind;
    SCVector up;
};
typedef struct SAim SAim;

#pragma pack(push, 1)
struct SOnfootData {
    SControllerState m_controllerState;
    SCVector m_position;
    float m_fQuaternion[4];
    unsigned char m_nHealth;
    unsigned char m_nArmor;
    unsigned char m_nCurrentWeapon;
    unsigned char m_nSpecialAction;
    SCVector m_speed;
    SCVector m_surfingOffset;
    ID m_nSurfingVehicleId;
    SAnimation m_animation;
};
typedef struct SOnfootData SOnfootData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SIncarData {
    ID m_nVehicle;
    SControllerState m_controllerState;
    float m_fQuaternion[4];
    SCVector m_position;
    SCVector m_speed;
    float m_fHealth;
    unsigned char m_nDriverHealth;
    unsigned char m_nDriverArmor;
    unsigned char m_nCurrentWeapon;
    bool m_bSirenEnabled;
    bool m_bLandingGear;
    ID m_nTrailerId;
    union {
        short unsigned int m_aHydraThrustAngle[2]; float m_fTrainSpeed;
    };
};
typedef struct SIncarData SIncarData;
#pragma pack(pop)

enum SWeaponState {
    WS_NO_BULLETS = 0,
    WS_LAST_BULLET = 1,
    WS_MORE_BULLETS = 2,
    WS_RELOADING = 3,
};
typedef enum SWeaponState SWeaponState;

#pragma pack(push, 1)
struct SAimData {
    unsigned char m_nCameraMode;
    SCVector m_aimf1;
    SCVector m_aimPos;
    float m_fAimZ;
    unsigned char m_nCameraExtZoom;
    unsigned char m_nWeaponState;
    char m_nAspectRatio;
};
typedef struct SAimData SAimData;
#pragma pack(pop)

#pragma pack(push, 1)
struct STrailerData {
    ID m_nId;
    SCVector m_position;
    float m_fQuaternion[4];
    SCVector m_speed;
    SCVector m_turnSpeed;
};
typedef struct STrailerData STrailerData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SPassengerData {
    ID m_nVehicleId;
    unsigned char m_nSeatId;
    unsigned char m_nCurrentWeapon;
    unsigned char m_nHealth;
    unsigned char m_nArmor;
    SControllerState m_controllerState;
    SCVector m_position;
};
typedef struct SPassengerData SPassengerData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SUnoccupiedData {
    ID m_nVehicleId;
    unsigned char m_nSeatId;
    SCVector m_roll;
    SCVector m_direction;
    SCVector m_position;
    SCVector m_speed;
    SCVector m_turnSpeed;
    float m_fHealth;
};
typedef struct SUnoccupiedData SUnoccupiedData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SBulletData {
    unsigned char m_nTargetType;
    ID m_nTargetId;
    SCVector m_origin;
    SCVector m_target;
    SCVector m_center;
    unsigned char m_nWeapon;
};
typedef struct SBulletData SBulletData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SSpectatorData {
    SControllerState m_controllerState;
    SCVector m_position;
};
typedef struct SSpectatorData SSpectatorData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SStatsData {
    int m_nMoney;
    int m_nDrunkLevel;
};
typedef struct SStatsData SStatsData;
#pragma pack(pop)
]]

shared.validate_size('struct SPools', 0x24)
shared.validate_size('struct SSettings', 0x3a)
shared.validate_size('struct SCNetGame', 0x3d1)
shared.validate_size('struct SAim', 0x30)
shared.validate_size('struct SOnfootData', 0x44)
shared.validate_size('struct SIncarData', 0x3f)
shared.validate_size('struct SAimData', 0x1f)
shared.validate_size('struct STrailerData', 0x36)
shared.validate_size('struct SPassengerData', 0x18)
shared.validate_size('struct SUnoccupiedData', 0x43)
shared.validate_size('struct SBulletData', 0x28)
shared.validate_size('struct SSpectatorData', 0x12)
shared.validate_size('struct SStatsData', 0x8)

local function RefNetGame() return ffi.cast('SCNetGame**', shared.GetAddress(0x21A0F8))[0] end
local function RefVehiclePoolProcessFlag() return ffi.cast('int*', shared.GetAddress(0x10496C))[0] end
local function RefPickupPoolProcessFlag() return ffi.cast('int*', shared.GetAddress(0x104970))[0] end
local function RefLastPlayersUpdateRequest() return ffi.cast('TICK*', shared.GetAddress(0x104978))[0] end

local SCNetGame_mt = {
    GetPickupPool = ffi.cast('SCPickupPool * (__thiscall*)(SCNetGame*)', shared.GetAddress(0x8130)),
    GetMenuPool = ffi.cast('SCMenuPool * (__thiscall*)(SCNetGame*)', shared.GetAddress(0x8140)),
    SetState = ffi.cast('void(__thiscall*)(SCNetGame*, int)', shared.GetAddress(0x8150)),
    InitializePools = ffi.cast('void(__thiscall*)(SCNetGame*)', shared.GetAddress(0x8160)),
    -- InitialNotification = ...
    InitializeGameLogic = ffi.cast('void(__thiscall*)(SCNetGame*)', shared.GetAddress(0x8510)),
    -- Connect = ...
    -- SpawnScreen = ...
    Packet_RSAPublicKeyMismatch = ffi.cast('void(__thiscall*)(SCNetGame*, SPacket * pPacket)', shared.GetAddress(0x8850)),
    Packet_ConnectionBanned = ffi.cast('void(__thiscall*)(SCNetGame*, SPacket * pPacket)', shared.GetAddress(0x8870)),
    Packet_ConnectionRequestAcepted = ffi.cast('void(__thiscall*)(SCNetGame*, SPacket*)', shared.GetAddress(0x8890)),
    Packet_NoFreeIncomingConnections = ffi.cast('void(__thiscall*)(SCNetGame*, SPacket * pPacket)', shared.GetAddress(0x88B0)),
    Packet_DisconnectionNotification = ffi.cast('void(__thiscall*)(SCNetGame*, SPacket*)', shared.GetAddress(0x88E0)),
    Packet_InvalidPassword = ffi.cast('void(__thiscall*)(SCNetGame*, SPacket * pPacket)', shared.GetAddress(0x8920)),
    Packet_ConnectionAttemptFailed = ffi.cast('void(__thiscall*)(SCNetGame*, SPacket * pPacket)', shared.GetAddress(0x8960)),
    UpdatePlayers = ffi.cast('void(__thiscall*)(SCNetGame*)', shared.GetAddress(0x8A10)),
    DeleteMarker = ffi.cast('void(__thiscall*)(SCNetGame*, NUMBER)', shared.GetAddress(0x8AB0)),
    ResetPlayerPool = ffi.cast('void(__thiscall*)(SCNetGame*)', shared.GetAddress(0x8AE0)),
    ResetVehiclePool = ffi.cast('void(__thiscall*)(SCNetGame*)', shared.GetAddress(0x8B80)),
    ResetTextDrawPool = ffi.cast('void(__thiscall*)(SCNetGame*)', shared.GetAddress(0x8C20)),
    ResetObjectPool = ffi.cast('void(__thiscall*)(SCNetGame*)', shared.GetAddress(0x8CC0)),
    ResetGangZonePool = ffi.cast('void(__thiscall*)(SCNetGame*)', shared.GetAddress(0x8D60)),
    ResetPickupPool = ffi.cast('void(__thiscall*)(SCNetGame*)', shared.GetAddress(0x8E00)),
    ResetMenuPool = ffi.cast('void(__thiscall*)(SCNetGame*)', shared.GetAddress(0x8E60)),
    ResetLabelPool = ffi.cast('void(__thiscall*)(SCNetGame*)', shared.GetAddress(0x8F00)),
    ResetActorPool = ffi.cast('void(__thiscall*)(SCNetGame*)', shared.GetAddress(0x8FA0)),
    Packet_UnoccupiedSync = ffi.cast('void(__thiscall*)(SCNetGame*, SPacket*)', shared.GetAddress(0x9550)),
    Packet_BulletSync = ffi.cast('void(__thiscall*)(SCNetGame*, SPacket*)', shared.GetAddress(0x9650)),
    Packet_AimSync = ffi.cast('void(__thiscall*)(SCNetGame*, SPacket*)', shared.GetAddress(0x9750)),
    Packet_PassengerSync = ffi.cast('void(__thiscall*)(SCNetGame*, SPacket*)', shared.GetAddress(0x9840)),
    Packet_TrailerSync = ffi.cast('void(__thiscall*)(SCNetGame*, SPacket*)', shared.GetAddress(0x9930)),
    Packet_MarkersSync = ffi.cast('void(__thiscall*)(SCNetGame*, SPacket*)', shared.GetAddress(0x9A20)),
    Packet_AuthKey = ffi.cast('void(__thiscall*)(SCNetGame*, SPacket*)', shared.GetAddress(0x9C10)),
    ResetMarkers = ffi.cast('void(__thiscall*)(SCNetGame*)', shared.GetAddress(0x9DE0)),
    CreateMarker = ffi.cast('void(__thiscall*)(SCNetGame*, NUMBER, SCVector, char, int, int)', shared.GetAddress(0x9E20)),
    ResetPools = ffi.cast('void(__thiscall*)(SCNetGame*)', shared.GetAddress(0xA010)),
    ShutdownForRestart = ffi.cast('void(__thiscall*)(SCNetGame*)', shared.GetAddress(0xA060)),
    Packet_PlayerSync = ffi.cast('void(__thiscall*)(SCNetGame*, SPacket*)', shared.GetAddress(0xA250)),
    Packet_VehicleSync = ffi.cast('void(__thiscall*)(SCNetGame*, SPacket*)', shared.GetAddress(0xA520)),
    Packet_ConnectionLost = ffi.cast('void(__thiscall*)(SCNetGame*, SPacket*)', shared.GetAddress(0xA800)),
    Packet_ConnectionSucceeded = ffi.cast('void(__thiscall*)(SCNetGame*, SPacket*)', shared.GetAddress(0xA890)),
    UpdateNetwork = ffi.cast('void(__thiscall*)(SCNetGame*)', shared.GetAddress(0xAD70)),
    -- Process = ...
    ProcessGameStuff = ffi.cast('void(__thiscall*)(SCNetGame*)', shared.GetAddress(0x8680)),
    GetPlayerPool = ffi.cast('SCPlayerPool * (__thiscall*)(SCNetGame*)', shared.GetAddress(0x1160)),
    GetObjectPool = ffi.cast('SCObjectPool * (__thiscall*)(SCNetGame*)', shared.GetAddress(0x2E00)),
    GetActorPool = ffi.cast('SCActorPool * (__thiscall*)(SCNetGame*)', shared.GetAddress(0x2E10)),
    GetState = ffi.cast('int(__thiscall*)(SCNetGame*)', shared.GetAddress(0x2E20)),
    LanMode = ffi.cast('BOOL(__thiscall*)(SCNetGame*)', shared.GetAddress(0x2E30)),
    GetVehiclePool = ffi.cast('SCVehiclePool * (__thiscall*)(SCNetGame*)', shared.GetAddress(0x1170)),
    GetRakClient = ffi.cast('SRakClientInterface * (__thiscall*)(SCNetGame*)', shared.GetAddress(0x1A40)),
    GetCounter = ffi.cast('__int64(__thiscall*)(SCNetGame*)', shared.GetAddress(0x8500)),
}
SCNetGame_mt.__index = SCNetGame_mt
ffi.metatype('struct SCNetGame', SCNetGame_mt)

local AimStuff = {}

-- RefLocalPlayerCameraExtZoom = ...
-- RefLocalPlayerAspectRatio = ...
-- RefInternalCameraExtZoom = ...
-- RefInternalAspectRatio = ...
-- ArrayCameraExtZoom = ...
-- ArrayAspectRatio = ...
-- ArrayCameraMode = ...
-- RefInternalCameraMode = ...
-- RefLocalPlayerAim = ...
-- ArrayPlayerAim = ...
-- RefInternalAim = ...
-- UpdateCameraExtZoomAndAspectRatio = ...
-- ApplyCameraExtZoomAndAspectRatio = ...
-- SetCameraExtZoomAndAspectRatio = ...
-- GetAspectRatio = ...
-- GetCameraExtZoom = ...
-- ApplyCameraExtZoomAndAspectRatio = ...
-- SetCameraMode = ...
-- GetCameraMode = ...
-- GetCameraMode = ...
-- Initialize = ...
-- UpdateAim = ...
-- ApplyAim = ...
-- GetAim = ...
-- SetAim = ...
-- ApplyAim = ...
-- GetAim = ...
local Synchronization = {}

-- CompressAspectRatio = ...
-- DecompressAspectRatio = ...
-- CompressCameraExtZoom = ...
-- DecompressCameraExtZoom = ...

return {
    RefNetGame = RefNetGame,
    RefVehiclePoolProcessFlag = RefVehiclePoolProcessFlag,
    RefPickupPoolProcessFlag = RefPickupPoolProcessFlag,
    RefLastPlayersUpdateRequest = RefLastPlayersUpdateRequest,
    AimStuff = AimStuff,
    Synchronization = Synchronization,
}