local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.ffi.cdef[[
#pragma pack(push, 1)
struct SCNetStats {
    long unsigned int m_dwLastTotalBytesSent;
    long unsigned int m_dwLastTotalBytesRecv;
    long unsigned int m_dwLastUpdateTick;
    long unsigned int m_dwBPSUpload;
    long unsigned int m_dwBPSDownload;
    IDirect3DDevice9* m_pDevice;
};
typedef struct SCNetStats SCNetStats;
#pragma pack(pop)
]]

shared.validate_size('struct SCNetStats', 0x18)

local CNetStats_constructor = ffi.cast('void(__thiscall*)(SCNetStats*, IDirect3DDevice9*)', 0x5D220)
local function CNetStats_new(...)
    local obj = ffi.new('struct SCNetStats[1]')
    CNetStats_constructor(obj, ...)
    return obj
end

local SCNetStats_mt = {
    Draw = ffi.cast('void(__thiscall*)(SCNetStats*)', shared.GetAddress(0x5D250)),
}
SCNetStats_mt.__index = SCNetStats_mt
ffi.metatype('struct SCNetStats', SCNetStats_mt)

local function RefNetStats() return ffi.cast('SCNetStats**', shared.GetAddress(0x21A0D0))[0] end

return {
    new = CNetStats_new,
    RefNetStats = RefNetStats,
}