local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.ffi.cdef[[
#pragma pack(push, 1)
struct SCObjectSelection {
    BOOL m_bIsActive;
    ID m_nHoveredObject;
};
typedef struct SCObjectSelection SCObjectSelection;
#pragma pack(pop)
]]

shared.validate_size('struct SCObjectSelection', 0x6)

local CObjectSelection_constructor = ffi.cast('void(__thiscall*)(SCObjectSelection*)', 0x69320)
local function CObjectSelection_new(...)
    local obj = ffi.new('struct SCObjectSelection[1]')
    CObjectSelection_constructor(obj, ...)
    return obj
end

local SCObjectSelection_mt = {
    DefineObject = ffi.cast('ID(__thiscall*)(SCObjectSelection*)', shared.GetAddress(0x69330)),
    DrawLabels = ffi.cast('void(__thiscall*)(SCObjectSelection*)', shared.GetAddress(0x69380)),
    Enable = ffi.cast('void(__thiscall*)(SCObjectSelection*, BOOL)', shared.GetAddress(0x694A0)),
    Draw = ffi.cast('void(__thiscall*)(SCObjectSelection*)', shared.GetAddress(0x69520)),
    SendNotification = ffi.cast('void(__thiscall*)(SCObjectSelection*)', shared.GetAddress(0x695F0)),
    MsgProc = ffi.cast('BOOL(__thiscall*)(SCObjectSelection*, int, int, int)', shared.GetAddress(0x69760)),
}
SCObjectSelection_mt.__index = SCObjectSelection_mt
ffi.metatype('struct SCObjectSelection', SCObjectSelection_mt)

local function RefObjectSelection() return ffi.cast('SCObjectSelection**', shared.GetAddress(0x21A0C8))[0] end

return {
    new = CObjectSelection_new,
    RefObjectSelection = RefObjectSelection,
}