local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.require 'CVector'

shared.ffi.cdef[[
#pragma pack(push, 1)
struct SPickup {
    int m_nModel;
    int m_nType;
    SCVector m_position;
};
typedef struct SPickup SPickup;
#pragma pack(pop)

#pragma pack(push, 1)
struct SWeaponPickup {
    bool m_bExists;
    ID m_nExOwner;
};
typedef struct SWeaponPickup SWeaponPickup;
#pragma pack(pop)

enum {
    MAX_PICKUPS = 4096,
};

#pragma pack(push, 1)
struct SCPickupPool {
    int m_nCount;
    GTAREF m_handle[4096];
    int m_nId[4096];
    long unsigned int m_nTimer[4096];
    SWeaponPickup m_weapon[4096];
    SPickup m_object[4096];
};
typedef struct SCPickupPool SCPickupPool;
#pragma pack(pop)
]]

shared.validate_size('struct SPickup', 0x14)
shared.validate_size('struct SWeaponPickup', 0x3)
shared.validate_size('struct SCPickupPool', 0x23004)

local CPickupPool_constructor = ffi.cast('void(__thiscall*)(SCPickupPool*)', 0x80F0)
local CPickupPool_destructor = ffi.cast('void(__thiscall*)(SCPickupPool*)', 0xFF60)
local function CPickupPool_new(...)
    local obj = ffi.gc(ffi.new('struct SCPickupPool[1]'), CPickupPool_destructor)
    CPickupPool_constructor(obj, ...)
    return obj
end

local SCPickupPool_mt = {
    Create = ffi.cast('void(__thiscall*)(SCPickupPool*, SPickup*, int)', shared.GetAddress(0xFDC0)),
    CreateWeapon = ffi.cast('void(__thiscall*)(SCPickupPool*, int, SCVector, int, ID)', shared.GetAddress(0xFCD0)),
    Delete = ffi.cast('void(__thiscall*)(SCPickupPool*, int)', shared.GetAddress(0xFE70)),
    DeleteWeapon = ffi.cast('void(__thiscall*)(SCPickupPool*, ID)', shared.GetAddress(0xFED0)),
    GetIndex = ffi.cast('int(__thiscall*)(SCPickupPool*, int)', shared.GetAddress(0xFF30)),
    SendNotification = ffi.cast('void(__thiscall*)(SCPickupPool*, int)', shared.GetAddress(0xFF90)),
    Process = ffi.cast('void(__thiscall*)(SCPickupPool*)', shared.GetAddress(0x10070)),
}
SCPickupPool_mt.__index = SCPickupPool_mt
ffi.metatype('struct SCPickupPool', SCPickupPool_mt)

return {
    new = CPickupPool_new,
}