local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.require 'CVector'

shared.ffi.cdef[[
#pragma pack(push, 1)
struct SCPlayerTags {
    IDirect3DDevice9* m_pDevice;
    IDirect3DStateBlock9* m_pStates;
    ID3DXSprite* m_pSprite;
};
typedef struct SCPlayerTags SCPlayerTags;
#pragma pack(pop)
]]

shared.validate_size('struct SCPlayerTags', 0xc)

local CPlayerTags_constructor = ffi.cast('void(__thiscall*)(SCPlayerTags*, IDirect3DDevice9*)', 0x68610)
local CPlayerTags_destructor = ffi.cast('void(__thiscall*)(SCPlayerTags*)', 0x68640)
local function CPlayerTags_new(...)
    local obj = ffi.gc(ffi.new('struct SCPlayerTags[1]'), CPlayerTags_destructor)
    CPlayerTags_constructor(obj, ...)
    return obj
end

local SCPlayerTags_mt = {
    EndHealthBar = ffi.cast('void(__thiscall*)(SCPlayerTags*)', shared.GetAddress(0x68670)),
    BeginLabel = ffi.cast('void(__thiscall*)(SCPlayerTags*)', shared.GetAddress(0x686A0)),
    EndLabel = ffi.cast('void(__thiscall*)(SCPlayerTags*)', shared.GetAddress(0x686B0)),
    DrawLabel = ffi.cast('void(__thiscall*)(SCPlayerTags*, SCVector*, const char*, D3DCOLOR, float, bool, int)', shared.GetAddress(0x686C0)),
    DrawHealthBar = ffi.cast('void(__thiscall*)(SCPlayerTags*, SCVector*, float, float, float)', shared.GetAddress(0x689C0)),
    OnLostDevice = ffi.cast('void(__thiscall*)(SCPlayerTags*)', shared.GetAddress(0x68F70)),
    OnResetDevice = ffi.cast('void(__thiscall*)(SCPlayerTags*)', shared.GetAddress(0x68FA0)),
    BeginHealthBar = ffi.cast('void(__thiscall*)(SCPlayerTags*)', shared.GetAddress(0x68FD0)),
}
SCPlayerTags_mt.__index = SCPlayerTags_mt
ffi.metatype('struct SCPlayerTags', SCPlayerTags_mt)

local function RefPlayerTags() return ffi.cast('SCPlayerTags**', shared.GetAddress(0x21A0B0))[0] end

return {
    new = CPlayerTags_new,
    RefPlayerTags = RefPlayerTags,
}