local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.require 'CRect'

shared.ffi.cdef[[
#pragma pack(push, 1)
struct SCScoreboard {
    BOOL m_bIsEnabled;
    int m_nPlayerCount;
    float m_position[2];
    float m_fScalar;
    float m_size[2];
    float pad[5];
    IDirect3DDevice9* m_pDevice;
    CDXUTDialog* m_pDialog;
    CDXUTListBox* m_pListBox;
    int m_nCurrentOffset;
    BOOL m_bIsSorted;
};
typedef struct SCScoreboard SCScoreboard;
#pragma pack(pop)
]]

shared.validate_size('struct SCScoreboard', 0x44)

local CScoreboard_constructor = ffi.cast('void(__thiscall*)(SCScoreboard*, IDirect3DDevice9*)', 0x6A370)
local function CScoreboard_new(...)
    local obj = ffi.new('struct SCScoreboard[1]')
    CScoreboard_constructor(obj, ...)
    return obj
end

local SCScoreboard_mt = {
    Recalc = ffi.cast('void(__thiscall*)(SCScoreboard*)', shared.GetAddress(0x6A270)),
    GetRect = ffi.cast('void(__thiscall*)(SCScoreboard*, SCRect*)', shared.GetAddress(0x6A2D0)),
    Close = ffi.cast('void(__thiscall*)(SCScoreboard*, bool)', shared.GetAddress(0x6A320)),
    ResetDialogControls = ffi.cast('void(__thiscall*)(SCScoreboard*, CDXUTDialog*)', shared.GetAddress(0x6A3F0)),
    SendNotification = ffi.cast('void(__thiscall*)(SCScoreboard*)', shared.GetAddress(0x6A550)),
    UpdateList = ffi.cast('void(__thiscall*)(SCScoreboard*)', shared.GetAddress(0x6A680)),
    Draw = ffi.cast('void(__thiscall*)(SCScoreboard*)', shared.GetAddress(0x6AA10)),
    Enable = ffi.cast('void(__thiscall*)(SCScoreboard*)', shared.GetAddress(0x6AD30)),
}
SCScoreboard_mt.__index = SCScoreboard_mt
ffi.metatype('struct SCScoreboard', SCScoreboard_mt)

local function RefScoreboard() return ffi.cast('SCScoreboard**', shared.GetAddress(0x21A0B4))[0] end

return {
    new = CScoreboard_new,
    RefScoreboard = RefScoreboard,
}