local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.require 'CRect'
shared.require 'v037r1.CFonts'

shared.ffi.cdef[[
#pragma pack(push, 1)
struct SCSpawnScreen {
    BOOL m_bEnabled;
    char* m_szSpawnText;
    SCFonts* m_pFont;
    IDirect3DDevice9* m_pDevice;
    IDirect3DTexture9* m_pTexture;
    IDirect3DStateBlock9* m_pStateBlockSaved;
    IDirect3DStateBlock9* m_pStateBlockDraw;
    void* m_pSprite;
};
typedef struct SCSpawnScreen SCSpawnScreen;
#pragma pack(pop)
]]

shared.validate_size('struct SCSpawnScreen', 0x20)

local function RefSpawnScreen() return ffi.cast('SCSpawnScreen**', shared.GetAddress(0x21A0F4))[0] end
local CSpawnScreen_constructor = ffi.cast('void(__thiscall*)(SCSpawnScreen*, IDirect3DDevice9*)', 0x6C910)
local CSpawnScreen_destructor = ffi.cast('void(__thiscall*)(SCSpawnScreen*)', 0x6C950)
local function CSpawnScreen_new(...)
    local obj = ffi.gc(ffi.new('struct SCSpawnScreen[1]'), CSpawnScreen_destructor)
    CSpawnScreen_constructor(obj, ...)
    return obj
end

local SCSpawnScreen_mt = {
    SetText = ffi.cast('void(__thiscall*)(SCSpawnScreen*, const char*)', shared.GetAddress(0x6C5B0)),
    OnResetDevice = ffi.cast('void(__thiscall*)(SCSpawnScreen*)', shared.GetAddress(0x6C610)),
    OnLostDevice = ffi.cast('void(__thiscall*)(SCSpawnScreen*)', shared.GetAddress(0x6C8C0)),
    Draw = ffi.cast('void(__thiscall*)(SCSpawnScreen*)', shared.GetAddress(0x6C9B0)),
}
SCSpawnScreen_mt.__index = SCSpawnScreen_mt
ffi.metatype('struct SCSpawnScreen', SCSpawnScreen_mt)

return {
    RefSpawnScreen = RefSpawnScreen,
    new = CSpawnScreen_new,
}