local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.ffi.cdef[[
#pragma pack(push, 1)
struct SCSrvNetStats {
    long unsigned int m_dwLastTotalBytesSent;
    long unsigned int m_dwLastTotalBytesRecv;
    long unsigned int m_dwLastUpdateTick;
    long unsigned int m_dwBPSUpload;
    long unsigned int m_dwBPSDownload;
    IDirect3DDevice9* m_pDevice;
};
typedef struct SCSrvNetStats SCSrvNetStats;
#pragma pack(pop)
]]

shared.validate_size('struct SCSrvNetStats', 0x18)

local CSrvNetStats_constructor = ffi.cast('void(__thiscall*)(SCSrvNetStats*, IDirect3DDevice9*)', 0x6CC40)
local function CSrvNetStats_new(...)
    local obj = ffi.new('struct SCSrvNetStats[1]')
    CSrvNetStats_constructor(obj, ...)
    return obj
end

local SCSrvNetStats_mt = {
    Draw = ffi.cast('void(__thiscall*)(SCSrvNetStats*)', shared.GetAddress(0x6CC80)),
}
SCSrvNetStats_mt.__index = SCSrvNetStats_mt
ffi.metatype('struct SCSrvNetStats', SCSrvNetStats_mt)

local function RefServerNetStatistics() return ffi.cast('SCSrvNetStats**', shared.GetAddress(0x21A0D4))[0] end

return {
    new = CSrvNetStats_new,
    RefServerNetStatistics = RefServerNetStatistics,
}