local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.ffi.cdef[[
#pragma pack(push, 1)
struct SCTextDrawSelection {
    BOOL m_bIsActive;
    D3DCOLOR m_hoveredColor;
    ID m_nHoveredId;
};
typedef struct SCTextDrawSelection SCTextDrawSelection;
#pragma pack(pop)
]]

shared.validate_size('struct SCTextDrawSelection', 0xa)

local SCTextDrawSelection_mt = {
    ResetTextDraws = ffi.cast('void(__thiscall*)(SCTextDrawSelection*)', shared.GetAddress(0x6CCD0)),
    RawProcess = ffi.cast('void(__thiscall*)(SCTextDrawSelection*)', shared.GetAddress(0x6CD30)),
    Process = ffi.cast('void(__thiscall*)(SCTextDrawSelection*)', shared.GetAddress(0x6CE30)),
    Enable = ffi.cast('void(__thiscall*)(SCTextDrawSelection*, D3DCOLOR)', shared.GetAddress(0x6CE60)),
    SendNotification = ffi.cast('void(__thiscall*)(SCTextDrawSelection*)', shared.GetAddress(0x6CEA0)),
    Disable = ffi.cast('void(__thiscall*)(SCTextDrawSelection*)', shared.GetAddress(0x6CF40)),
    MsgProc = ffi.cast('BOOL(__thiscall*)(SCTextDrawSelection*, int, int, int)', shared.GetAddress(0x6CF90)),
}
SCTextDrawSelection_mt.__index = SCTextDrawSelection_mt
ffi.metatype('struct SCTextDrawSelection', SCTextDrawSelection_mt)

local function RefTextDrawSelection() return ffi.cast('SCTextDrawSelection**', shared.GetAddress(0x21A0CC))[0] end

return {
    RefTextDrawSelection = RefTextDrawSelection,
}