local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.ffi.cdef[[
enum {
    DEBUG_MODE_VEHICLE_SELECTION = 10,
};
]]

local function RefMode() return ffi.cast('int*', shared.GetAddress(0x13BB18))[0] end
local function RefFirstEntity() return ffi.cast('void**', shared.GetAddress(0x13BB1C))[0] end
local function RefSecondEntity() return ffi.cast('void**', shared.GetAddress(0x13BB20))[0] end
local SetProperties = ffi.cast('void(__cdecl*)(void*, void*, int)', shared.GetAddress(0x996E0))
local Disable = ffi.cast('void(__cdecl*)()', shared.GetAddress(0x99700))

return {
    RefMode = RefMode,
    RefFirstEntity = RefFirstEntity,
    RefSecondEntity = RefSecondEntity,
    SetProperties = SetProperties,
    Disable = Disable,
}