local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.ffi.cdef[[
enum {
    MAX_ANTICHEAT_DETECT_COUNT = 10,
};
]]

local SwitchWindowedMode = ffi.cast('void(__cdecl*)()', shared.GetAddress(0x5D800))
local function RefPrevWindowProc() return ffi.cast('void**', shared.GetAddress(0x119CB8))[0] end
local function RefAntiCheatDetectCount() return ffi.cast('unsigned int*', shared.GetAddress(0x21A130))[0] end
local WindowProc = ffi.cast('int(__stdcall*)(unsigned int, unsigned int, long)', shared.GetAddress(0x5DB40))
local KeyPressHandler = ffi.cast('BOOL(__cdecl*)(unsigned int)', shared.GetAddress(0x5D850))
local CharInputHandler = ffi.cast('BOOL(__cdecl*)(unsigned int)', shared.GetAddress(0x5DA80))
local Initialize = ffi.cast('BOOL(__cdecl*)()', shared.GetAddress(0x5E3B0))

return {
    SwitchWindowedMode = SwitchWindowedMode,
    RefPrevWindowProc = RefPrevWindowProc,
    RefAntiCheatDetectCount = RefAntiCheatDetectCount,
    WindowProc = WindowProc,
    KeyPressHandler = KeyPressHandler,
    CharInputHandler = CharInputHandler,
    Initialize = Initialize,
}