local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.require 'v037r1.CEntity'
shared.require 'v037r1.CVehicle'
shared.require 'v037r1.CPed'
shared.require 'v037r1.CPlayerPool'
shared.require 'v037r1.CObject'
shared.require 'v037r1.CNetGame'
shared.require 'CMatrix'
shared.require 'CVector'
shared.require 'v037r1.CLabelPool'
shared.require 'v037r1.CActorPool'
shared.require 'v037r1.CActor'
shared.require 'v037r1.CObjectPool'
shared.require 'v037r1.CMenuPool'
shared.require 'v037r1.CMenu'
shared.require 'v037r1.CTextDrawPool'
shared.require 'v037r1.CTextDraw'
shared.require 'v037r1.CGangZonePool'
shared.require 'v037r1.CPickupPool'
shared.require 'v037r1.CVehiclePool'
shared.require 'v037r1.CLocalPlayer'
shared.require 'v037r1.CPlayerInfo'
shared.require 'v037r1.CRemotePlayer'
shared.require 'v037r1.SpecialAction'
shared.require 'v037r1.ControllerState'
shared.require 'v037r1.Animation'
shared.require 'v037r1.AimStuff'
shared.require 'v037r1.Synchronization'

shared.ffi.cdef[[
#pragma pack(push, 1)
struct SDeathNotification {
    unsigned char m_nReason;
    short unsigned int m_nKiller;
};
typedef struct SDeathNotification SDeathNotification;
#pragma pack(pop)

#pragma pack(push, 1)
struct SSpawn {
};
typedef struct SSpawn SSpawn;
#pragma pack(pop)

#pragma pack(push, 1)
struct SUpdateVehicleDamage {
    short unsigned int m_nVehicle;
    unsigned int m_nPanels;
    unsigned int m_nDoors;
    unsigned char m_nLights;
    unsigned char m_nTyres;
};
typedef struct SUpdateVehicleDamage SUpdateVehicleDamage;
#pragma pack(pop)

#pragma pack(push, 1)
struct SClassRequest {
    int m_nClass;
};
typedef struct SClassRequest SClassRequest;
#pragma pack(pop)

#pragma pack(push, 1)
struct SSpawnRequest {
};
typedef struct SSpawnRequest SSpawnRequest;
#pragma pack(pop)

#pragma pack(push, 1)
struct SInteriorChangeNotification {
    unsigned char m_nId;
};
typedef struct SInteriorChangeNotification SInteriorChangeNotification;
#pragma pack(pop)

#pragma pack(push, 1)
struct SEnterVehicleNotification {
    short unsigned int m_nVehicle;
    bool m_bPassenger;
};
typedef struct SEnterVehicleNotification SEnterVehicleNotification;
#pragma pack(pop)

#pragma pack(push, 1)
struct SExitVehicleNotification {
    short unsigned int m_nVehicle;
};
typedef struct SExitVehicleNotification SExitVehicleNotification;
#pragma pack(pop)

#pragma pack(push, 1)
struct SUpdatePlayersInfo {
};
typedef struct SUpdatePlayersInfo SUpdatePlayersInfo;
#pragma pack(pop)

#pragma pack(push, 1)
struct SClickPlayer {
    short unsigned int m_nPlayer;
    char m_nSource;
};
typedef struct SClickPlayer SClickPlayer;
#pragma pack(pop)

struct SAim {
    SCVector front;
    SCVector source;
    SCVector sourceBeforeLookBehind;
    SCVector up;
};
typedef struct SAim SAim;

#pragma pack(push, 1)
struct SOnfootData {
    SControllerState m_controllerState;
    SCVector m_position;
    float m_fQuaternion[4];
    unsigned char m_nHealth;
    unsigned char m_nArmor;
    unsigned char m_nCurrentWeapon;
    unsigned char m_nSpecialAction;
    SCVector m_speed;
    SCVector m_surfingOffset;
    ID m_nSurfingVehicleId;
    SAnimation m_animation;
};
typedef struct SOnfootData SOnfootData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SIncarData {
    ID m_nVehicle;
    SControllerState m_controllerState;
    float m_fQuaternion[4];
    SCVector m_position;
    SCVector m_speed;
    float m_fHealth;
    unsigned char m_nDriverHealth;
    unsigned char m_nDriverArmor;
    unsigned char m_nCurrentWeapon;
    bool m_bSirenEnabled;
    bool m_bLandingGear;
    ID m_nTrailerId;
    union {
        short unsigned int m_aHydraThrustAngle[2]; float m_fTrainSpeed;
    };
};
typedef struct SIncarData SIncarData;
#pragma pack(pop)

enum SWeaponState {
    WS_NO_BULLETS = 0,
    WS_LAST_BULLET = 1,
    WS_MORE_BULLETS = 2,
    WS_RELOADING = 3,
};
typedef enum SWeaponState SWeaponState;

#pragma pack(push, 1)
struct SAimData {
    unsigned char m_nCameraMode;
    SCVector m_aimf1;
    SCVector m_aimPos;
    float m_fAimZ;
    unsigned char m_nCameraExtZoom;
    unsigned char m_nWeaponState;
    char m_nAspectRatio;
};
typedef struct SAimData SAimData;
#pragma pack(pop)

#pragma pack(push, 1)
struct STrailerData {
    ID m_nId;
    SCVector m_position;
    float m_fQuaternion[4];
    SCVector m_speed;
    SCVector m_turnSpeed;
};
typedef struct STrailerData STrailerData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SPassengerData {
    ID m_nVehicleId;
    unsigned char m_nSeatId;
    unsigned char m_nCurrentWeapon;
    unsigned char m_nHealth;
    unsigned char m_nArmor;
    SControllerState m_controllerState;
    SCVector m_position;
};
typedef struct SPassengerData SPassengerData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SUnoccupiedData {
    ID m_nVehicleId;
    unsigned char m_nSeatId;
    SCVector m_roll;
    SCVector m_direction;
    SCVector m_position;
    SCVector m_speed;
    SCVector m_turnSpeed;
    float m_fHealth;
};
typedef struct SUnoccupiedData SUnoccupiedData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SBulletData {
    unsigned char m_nTargetType;
    ID m_nTargetId;
    SCVector m_origin;
    SCVector m_target;
    SCVector m_center;
    unsigned char m_nWeapon;
};
typedef struct SBulletData SBulletData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SSpectatorData {
    SControllerState m_controllerState;
    SCVector m_position;
};
typedef struct SSpectatorData SSpectatorData;
#pragma pack(pop)

#pragma pack(push, 1)
struct SStatsData {
    int m_nMoney;
    int m_nDrunkLevel;
};
typedef struct SStatsData SStatsData;
#pragma pack(pop)
]]

shared.validate_size('struct SDeathNotification', 0x3)
shared.validate_size('struct SSpawn', 0x1)
shared.validate_size('struct SUpdateVehicleDamage', 0xc)
shared.validate_size('struct SClassRequest', 0x4)
shared.validate_size('struct SSpawnRequest', 0x1)
shared.validate_size('struct SInteriorChangeNotification', 0x1)
shared.validate_size('struct SEnterVehicleNotification', 0x3)
shared.validate_size('struct SExitVehicleNotification', 0x2)
shared.validate_size('struct SUpdatePlayersInfo', 0x1)
shared.validate_size('struct SClickPlayer', 0x3)
shared.validate_size('struct SAim', 0x30)
shared.validate_size('struct SOnfootData', 0x44)
shared.validate_size('struct SIncarData', 0x3f)
shared.validate_size('struct SAimData', 0x1f)
shared.validate_size('struct STrailerData', 0x36)
shared.validate_size('struct SPassengerData', 0x18)
shared.validate_size('struct SUnoccupiedData', 0x43)
shared.validate_size('struct SBulletData', 0x28)
shared.validate_size('struct SSpectatorData', 0x12)
shared.validate_size('struct SStatsData', 0x8)

local Incoming = {}

local Outcoming = {}

local AimStuff = {}

-- RefLocalPlayerCameraExtZoom = ...
-- RefLocalPlayerAspectRatio = ...
-- RefInternalCameraExtZoom = ...
-- RefInternalAspectRatio = ...
-- ArrayCameraExtZoom = ...
-- ArrayAspectRatio = ...
-- ArrayCameraMode = ...
-- RefInternalCameraMode = ...
-- RefLocalPlayerAim = ...
-- ArrayPlayerAim = ...
-- RefInternalAim = ...
-- UpdateCameraExtZoomAndAspectRatio = ...
-- ApplyCameraExtZoomAndAspectRatio = ...
-- SetCameraExtZoomAndAspectRatio = ...
-- GetAspectRatio = ...
-- GetCameraExtZoom = ...
-- ApplyCameraExtZoomAndAspectRatio = ...
-- SetCameraMode = ...
-- GetCameraMode = ...
-- GetCameraMode = ...
-- Initialize = ...
-- UpdateAim = ...
-- ApplyAim = ...
-- GetAim = ...
-- SetAim = ...
-- ApplyAim = ...
-- GetAim = ...
local Synchronization = {}

-- CompressAspectRatio = ...
-- DecompressAspectRatio = ...
-- CompressCameraExtZoom = ...
-- DecompressCameraExtZoom = ...

return {
    Incoming = Incoming,
    Outcoming = Outcoming,
    AimStuff = AimStuff,
    Synchronization = Synchronization,
}