local shared = require 'sampapi.shared'
local ffi = require 'ffi'

shared.ffi.cdef[[
enum {
    SETTINGS_STRING_LEN = 256,
};

#pragma pack(push, 1)
struct SSettings {
    BOOL m_bDebugMode;
    BOOL m_bOnlineGame;
    BOOL m_bWindowedMode;
    char m_szPass[257];
    char m_szHost[257];
    char m_szPort[257];
    char m_szNick[257];
    char m_szDebugScript[257];
};
typedef struct SSettings SSettings;
#pragma pack(pop)
]]

shared.validate_size('struct SSettings', 0x511)

local Initialize = ffi.cast('void(__cdecl*)()', shared.GetAddress(0xB2FF0))
local GetFromCommandLine = ffi.cast('void(__cdecl*)(const char*, char*)', shared.GetAddress(0xB28F0))
local GetFromQuotes = ffi.cast('void(__cdecl*)(const char*, char*)', shared.GetAddress(0xB2940))

local function RefSettings() return ffi.cast('SSettings*', shared.GetAddress(0x219760))[0] end

return {
    Initialize = Initialize,
    GetFromCommandLine = GetFromCommandLine,
    GetFromQuotes = GetFromQuotes,
    RefSettings = RefSettings,
}